/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.asm;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.mapper.AbstractMapper;
import org.simpleflatmapper.ow2asm.ClassWriter;
import org.simpleflatmapper.ow2asm.FieldVisitor;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.asm.AsmUtils;
import org.simpleflatmapper.util.TypeHelper;

public class MapperAsmBuilder {
    private static final String ABSTRACT_MAPPER_TYPE = AsmUtils.toAsmType(AbstractMapper.class);
    private static final String FIELD_MAPPER_TYPE = AsmUtils.toAsmType(FieldMapper.class);
    private static final String INSTANTIATOR_TYPE = AsmUtils.toAsmType(BiInstantiator.class);
    private static final String mappingContextType = AsmUtils.toAsmType(MappingContext.class);

    public static <S, T> byte[] dump(String className, FieldMapper<? super S, ? super T>[] mappers, FieldMapper<? super S, ? super T>[] constructorMappers, Class<? super S> sourceClass, Class<T> target) throws Exception {
        String mapper;
        String mapperName;
        int i;
        ClassWriter cw = new ClassWriter(1);
        String targetType = AsmUtils.toAsmType(target);
        String classType = AsmUtils.toAsmType((String)className);
        cw.visit(50, 49, classType, "L" + ABSTRACT_MAPPER_TYPE + "<" + AsmUtils.toTargetTypeDeclaration((String)targetType) + ">;", ABSTRACT_MAPPER_TYPE, null);
        for (i = 0; i < mappers.length; ++i) {
            MapperAsmBuilder.declareMapperFields(cw, mappers[i], i);
        }
        for (i = 0; i < constructorMappers.length; ++i) {
            MapperAsmBuilder.declareConstructorMapperFields(cw, constructorMappers[i], i);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "([L" + FIELD_MAPPER_TYPE + ";[L" + FIELD_MAPPER_TYPE + ";L" + INSTANTIATOR_TYPE + ";)V", "([L" + FIELD_MAPPER_TYPE + "<" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + ">;[L" + FIELD_MAPPER_TYPE + "<" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + ">;L" + INSTANTIATOR_TYPE + "<" + AsmUtils.toTargetTypeDeclaration((String)targetType) + ">;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, ABSTRACT_MAPPER_TYPE, "<init>", "(L" + INSTANTIATOR_TYPE + ";)V", false);
        for (i = 0; i < mappers.length; ++i) {
            MapperAsmBuilder.addFieldMapperInit(mv, mappers[i], i, classType);
        }
        for (i = 0; i < constructorMappers.length; ++i) {
            MapperAsmBuilder.addGConstructorFieldMapperInit(mv, constructorMappers[i], i, classType);
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(17, "mapFields", "(" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        for (i = 0; i < mappers.length; ++i) {
            MapperAsmBuilder.generateMappingCall(mv, mappers[i], i, classType, AsmUtils.toAsmType(sourceClass), targetType);
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv = cw.visitMethod(4161, "mapFields", "(Ljava/lang/Object;Ljava/lang/Object;" + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, AsmUtils.toAsmType(sourceClass));
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, targetType);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, classType, "mapFields", "(" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(20, "mapToFields", "(" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        for (i = 0; i < constructorMappers.length; ++i) {
            MapperAsmBuilder.generateConstructorMappingCall(mv, constructorMappers[i], i, classType, AsmUtils.toAsmType(sourceClass), targetType);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, classType, "mapFields", "(" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(4164, "mapToFields", "(Ljava/lang/Object;Ljava/lang/Object;" + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, AsmUtils.toAsmType(sourceClass));
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, targetType);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, classType, "mapToFields", "(" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitMethodInsn(182, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn((Object)"{");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitInsn(87);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, ABSTRACT_MAPPER_TYPE, "appendToStringBuilder", "(Ljava/lang/StringBuilder;)V", false);
        mv.visitVarInsn(25, 1);
        for (i = 0; i < mappers.length; ++i) {
            mapperName = ", fieldMapper" + i + "=";
            mapper = String.valueOf(mappers[i]);
            mv.visitLdcInsn((Object)mapperName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn((Object)mapper);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        for (i = 0; i < constructorMappers.length; ++i) {
            mapperName = ", constructorMapper" + i + "=";
            mapper = String.valueOf(constructorMappers[i]);
            mv.visitLdcInsn((Object)mapperName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn((Object)mapper);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        mv.visitLdcInsn((Object)"}");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        cw.visitEnd();
        return AsmUtils.writeClassToFile((String)className, (byte[])cw.toByteArray());
    }

    private static <S, T> void generateMappingCall(MethodVisitor mv, FieldMapper<S, T> mapper, int index, String classType, String sourceType, String targetType) {
        MapperAsmBuilder.generateMappingCall(mv, mapper, index, classType, sourceType, targetType, "fieldMapper");
    }

    private static <S, T> void generateConstructorMappingCall(MethodVisitor mv, FieldMapper<S, T> mapper, int index, String classType, String sourceType, String targetType) {
        MapperAsmBuilder.generateMappingCall(mv, mapper, index, classType, sourceType, targetType, "constructorMapper");
    }

    private static <S, T> void generateMappingCall(MethodVisitor mv, FieldMapper<S, T> mapper, int index, String classType, String sourceType, String targetType, String variablePrefix) {
        if (mapper == null) {
            return;
        }
        Type mapperClass = AsmUtils.findClosestPublicTypeExposing(mapper.getClass(), FieldMapper.class);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classType, variablePrefix + index, "L" + AsmUtils.toAsmType((Type)mapperClass) + ";");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        Method m = MapperAsmBuilder.getMapToMethod(TypeHelper.toClass((Type)mapperClass));
        AsmUtils.invoke((MethodVisitor)mv, (Type)mapperClass, (Method)m);
    }

    private static Method getMapToMethod(Class<?> aClass) {
        Method m = null;
        for (Method p : aClass.getDeclaredMethods()) {
            if (Modifier.isStatic(p.getModifiers()) || !p.getName().equals("mapTo") || p.getParameterTypes() == null || p.getParameterTypes().length != 3 || m != null && p.getModifiers() >= m.getModifiers()) continue;
            m = p;
        }
        return m;
    }

    private static <S, T> void addFieldMapperInit(MethodVisitor mv, FieldMapper<S, T> mapper, int index, String classType) {
        if (mapper == null) {
            return;
        }
        Type mapperClass = AsmUtils.findClosestPublicTypeExposing(mapper.getClass(), FieldMapper.class);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        AsmUtils.addIndex((MethodVisitor)mv, (int)index);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, AsmUtils.toAsmType((Type)mapperClass));
        mv.visitFieldInsn(181, classType, "fieldMapper" + index, AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType((Type)mapperClass)));
    }

    private static <S, T> void addGConstructorFieldMapperInit(MethodVisitor mv, FieldMapper<S, T> mapper, int index, String classType) {
        if (mapper == null) {
            return;
        }
        Type mapperClass = AsmUtils.findClosestPublicTypeExposing(mapper.getClass(), FieldMapper.class);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        AsmUtils.addIndex((MethodVisitor)mv, (int)index);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, AsmUtils.toAsmType((Type)mapperClass));
        mv.visitFieldInsn(181, classType, "constructorMapper" + index, AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType((Type)mapperClass)));
    }

    private static <S, T> void declareMapperFields(ClassWriter cw, FieldMapper<S, T> mapper, int index) {
        if (mapper == null) {
            return;
        }
        Type mapperClass = AsmUtils.findClosestPublicTypeExposing(mapper.getClass(), FieldMapper.class);
        FieldVisitor fv = cw.visitField(18, "fieldMapper" + index, AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType((Type)mapperClass)), AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toGenericAsmType((Type)mapperClass)), null);
        fv.visitEnd();
    }

    private static <S, T> void declareConstructorMapperFields(ClassWriter cw, FieldMapper<S, T> mapper, int index) {
        if (mapper == null) {
            return;
        }
        Type mapperClass = AsmUtils.findClosestPublicTypeExposing(mapper.getClass(), FieldMapper.class);
        FieldVisitor fv = cw.visitField(18, "constructorMapper" + index, AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType((Type)mapperClass)), AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toGenericAsmType((Type)mapperClass)), null);
        fv.visitEnd();
    }
}

