/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context;

import org.simpleflatmapper.map.context.Key;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.map.context.impl.MultiValueKey;
import org.simpleflatmapper.map.context.impl.SingleValueKey;
import org.simpleflatmapper.util.ErrorHelper;

public class KeyDefinition<S, K> {
    private final KeySourceGetter<K, ? super S> keySourceGetter;
    private final K[] keys;
    private final K singleKey;
    private final boolean empty;
    private final int index;

    public KeyDefinition(K[] keys, KeySourceGetter<K, ? super S> keySourceGetter, int index) {
        this.singleKey = KeyDefinition.getSingleKey(keys);
        this.keys = this.singleKey == null ? keys : null;
        this.keySourceGetter = keySourceGetter;
        this.empty = keys == null || keys.length == 0;
        this.index = index;
    }

    private static <K> K getSingleKey(K[] keys) {
        if (keys != null && keys.length == 1) {
            return keys[0];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Key getValues(S source) {
        if (this.empty) {
            throw new IllegalStateException("cannot get value on empty keys");
        }
        try {
            if (this.singleKey != null) {
                return this.singleValueKeys(source);
            }
            return this.multiValueKeys(source);
        }
        catch (Exception e) {
            return (Key)ErrorHelper.rethrow((Throwable)e);
        }
    }

    private Key singleValueKeys(S source) throws Exception {
        return new SingleValueKey(this.keySourceGetter.getValue(this.singleKey, source));
    }

    private Key multiValueKeys(S source) throws Exception {
        Object[] values = new Object[this.keys.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.keySourceGetter.getValue(this.keys[i], source);
        }
        return new MultiValueKey(values);
    }

    public int getIndex() {
        return this.index;
    }
}

