/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map;

import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.PropertyNameMatcherFactory;
import org.simpleflatmapper.map.error.RethrowConsumerErrorHandler;
import org.simpleflatmapper.map.error.RethrowFieldMapperErrorHandler;
import org.simpleflatmapper.map.error.RethrowMapperBuilderErrorHandler;
import org.simpleflatmapper.map.impl.IdentityFieldMapperColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.DefaultPropertyNameMatcherFactory;
import org.simpleflatmapper.util.Asserts;

public final class MapperConfig<K extends FieldKey<K>> {
    public static final int NO_ASM_MAPPER_THRESHOLD = 792;
    public static final int MAX_METHOD_SIZE = 128;
    private final ColumnDefinitionProvider<K> columnDefinitions;
    private final PropertyNameMatcherFactory propertyNameMatcherFactory;
    private final MapperBuilderErrorHandler mapperBuilderErrorHandler;
    private final boolean failOnAsm;
    private final int asmMapperNbFieldsLimit;
    private final FieldMapperErrorHandler<? super K> fieldMapperErrorHandler;
    private final ConsumerErrorHandler consumerErrorHandler;
    private final int maxMethodSize;
    private final boolean assumeInjectionModifiesValues;

    public static <K extends FieldKey<K>> MapperConfig<K> fieldMapperConfig() {
        return new MapperConfig<Object>(new IdentityFieldMapperColumnDefinitionProvider(), DefaultPropertyNameMatcherFactory.DEFAULT, RethrowMapperBuilderErrorHandler.INSTANCE, false, 792, RethrowFieldMapperErrorHandler.INSTANCE, RethrowConsumerErrorHandler.INSTANCE, 128, false);
    }

    public static <K extends FieldKey<K>> MapperConfig<K> config(ColumnDefinitionProvider<K> columnDefinitionProvider) {
        return new MapperConfig<Object>(columnDefinitionProvider, DefaultPropertyNameMatcherFactory.DEFAULT, RethrowMapperBuilderErrorHandler.INSTANCE, false, 792, RethrowFieldMapperErrorHandler.INSTANCE, RethrowConsumerErrorHandler.INSTANCE, 128, false);
    }

    private MapperConfig(ColumnDefinitionProvider<K> columnDefinitions, PropertyNameMatcherFactory propertyNameMatcherFactory, MapperBuilderErrorHandler mapperBuilderErrorHandler, boolean failOnAsm, int asmMapperNbFieldsLimit, FieldMapperErrorHandler<? super K> fieldMapperErrorHandler, ConsumerErrorHandler consumerErrorHandler, int maxMethodSize, boolean assumeInjectionModifiesValues) {
        this.columnDefinitions = columnDefinitions;
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        this.failOnAsm = failOnAsm;
        this.asmMapperNbFieldsLimit = asmMapperNbFieldsLimit;
        this.fieldMapperErrorHandler = fieldMapperErrorHandler;
        this.consumerErrorHandler = consumerErrorHandler;
        this.maxMethodSize = maxMethodSize;
        this.assumeInjectionModifiesValues = assumeInjectionModifiesValues;
    }

    public ColumnDefinitionProvider<K> columnDefinitions() {
        return this.columnDefinitions;
    }

    public PropertyNameMatcherFactory propertyNameMatcherFactory() {
        return this.propertyNameMatcherFactory;
    }

    public MapperBuilderErrorHandler mapperBuilderErrorHandler() {
        return this.mapperBuilderErrorHandler;
    }

    public boolean failOnAsm() {
        return this.failOnAsm;
    }

    public boolean assumeInjectionModifiesValues() {
        return this.assumeInjectionModifiesValues;
    }

    public int asmMapperNbFieldsLimit() {
        return this.asmMapperNbFieldsLimit;
    }

    public MapperConfig<K> columnDefinitions(ColumnDefinitionProvider<K> columnDefinitions) {
        Asserts.requireNonNull((String)"columnDefinitions", columnDefinitions);
        return new MapperConfig<K>(columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues);
    }

    public MapperConfig<K> propertyNameMatcherFactory(PropertyNameMatcherFactory propertyNameMatcherFactory) {
        return new MapperConfig<K>(this.columnDefinitions, (PropertyNameMatcherFactory)Asserts.requireNonNull((String)"propertyNameMatcherFactory", (Object)propertyNameMatcherFactory), this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues);
    }

    public MapperConfig<K> mapperBuilderErrorHandler(MapperBuilderErrorHandler mapperBuilderErrorHandler) {
        return new MapperConfig<K>(this.columnDefinitions, this.propertyNameMatcherFactory, (MapperBuilderErrorHandler)Asserts.requireNonNull((String)"mapperBuilderErrorHandler", (Object)mapperBuilderErrorHandler), this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues);
    }

    public MapperConfig<K> failOnAsm(boolean failOnAsm) {
        return new MapperConfig<K>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues);
    }

    public MapperConfig<K> assumeInjectionModifiesValues(boolean assumeInjectionModifiesValues) {
        return new MapperConfig<K>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, assumeInjectionModifiesValues);
    }

    public MapperConfig<K> asmMapperNbFieldsLimit(int asmMapperNbFieldsLimit) {
        return new MapperConfig<K>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues);
    }

    public MapperConfig<K> fieldMapperErrorHandler(FieldMapperErrorHandler<? super K> fieldMapperErrorHandler) {
        return new MapperConfig<K>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues);
    }

    public MapperConfig<K> consumerErrorHandler(ConsumerErrorHandler consumerErrorHandler) {
        return new MapperConfig<K>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues);
    }

    public ConsumerErrorHandler consumerErrorHandler() {
        return this.consumerErrorHandler;
    }

    @Deprecated
    public MapperConfig<K> rowHandlerErrorHandler(ConsumerErrorHandler rowHandlerErrorHandler) {
        return this.consumerErrorHandler(rowHandlerErrorHandler);
    }

    public ConsumerErrorHandler rowHandlerErrorHandler() {
        return this.consumerErrorHandler();
    }

    public boolean hasFieldMapperErrorHandler() {
        return this.fieldMapperErrorHandler != null && !(this.fieldMapperErrorHandler instanceof RethrowFieldMapperErrorHandler);
    }

    public FieldMapperErrorHandler<? super K> fieldMapperErrorHandler() {
        return this.fieldMapperErrorHandler;
    }

    public int maxMethodSize() {
        return this.maxMethodSize;
    }

    public MapperConfig<K> maxMethodSize(int maxMethodSize) {
        return new MapperConfig<K>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, maxMethodSize, this.assumeInjectionModifiesValues);
    }
}

