/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.simpleflatmapper.map.BreakDetector;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.context.KeysDefinition;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.impl.BreakDetectorImpl;
import org.simpleflatmapper.map.context.impl.BreakDetectorMappingContext;

public class BreakDetectorMappingContextFactory<S, K>
implements MappingContextFactory<S> {
    private final KeysDefinition<S, K>[] keyDefinitions;
    private final MappingContextFactory<S> delegateFactory;
    private final int rootDetector;
    private final int nbValues;
    private final int originalKeySize;

    public BreakDetectorMappingContextFactory(KeysDefinition<S, K>[] keyDefinitions, int rootDetector, MappingContextFactory<S> delegateFactory, int nbValues) {
        this.originalKeySize = keyDefinitions.length;
        this.keyDefinitions = this.reorder(keyDefinitions, rootDetector);
        this.rootDetector = rootDetector;
        this.delegateFactory = delegateFactory;
        this.nbValues = nbValues;
    }

    private KeysDefinition<S, K>[] reorder(KeysDefinition<S, K>[] keyDefinitions, int rootDetector) {
        KeysDefinition<S, K>[] wKeyDefinitions = Arrays.copyOf(keyDefinitions, keyDefinitions.length);
        ArrayList<KeysDefinition<S, K>> newDefinitions = new ArrayList<KeysDefinition<S, K>>();
        if (rootDetector != -1) {
            newDefinitions.add(wKeyDefinitions[rootDetector]);
            wKeyDefinitions[rootDetector] = null;
            this.appendChildren(rootDetector, wKeyDefinitions, newDefinitions);
        }
        this.appendChildren(-1, wKeyDefinitions, newDefinitions);
        for (int i = 0; i < wKeyDefinitions.length; ++i) {
            if (wKeyDefinitions[i] == null) continue;
            throw new IllegalStateException("Invalid State unconsumed keydefinition " + wKeyDefinitions[i]);
        }
        return newDefinitions.toArray(new KeysDefinition[0]);
    }

    private void appendChildren(int parent, KeysDefinition<S, K>[] wKeyDefinitions, ArrayList<KeysDefinition<S, K>> newDefinitions) {
        for (int i = 0; i < wKeyDefinitions.length; ++i) {
            KeysDefinition<S, K> definition = wKeyDefinitions[i];
            if (definition == null || definition.getParentIndex() != parent) continue;
            newDefinitions.add(definition);
            wKeyDefinitions[i] = null;
            this.appendChildren(definition.getIndex(), wKeyDefinitions, newDefinitions);
        }
    }

    @Override
    public MappingContext<S> newContext() {
        BreakDetector<S>[][] breakDetectors = this.newBreakDetectors(this.keyDefinitions);
        return new BreakDetectorMappingContext<S>(breakDetectors[1], breakDetectors[0], this.rootDetector, this.delegateFactory.newContext(), new Object[this.nbValues]);
    }

    private BreakDetector<S>[][] newBreakDetectors(KeysDefinition<S, K>[] definitions) {
        if (definitions == null) {
            return null;
        }
        BreakDetector[] processingOrderBreakDetectors = new BreakDetector[definitions.length];
        BreakDetector[] originalOrderedBreakDetectors = new BreakDetector[this.originalKeySize];
        for (int i = 0; i < definitions.length; ++i) {
            BreakDetectorImpl<S, K> breakDetector;
            KeysDefinition<S, K> definition = definitions[i];
            processingOrderBreakDetectors[i] = breakDetector = new BreakDetectorImpl<S, K>(definition, originalOrderedBreakDetectors);
            originalOrderedBreakDetectors[definition.getIndex()] = breakDetector;
        }
        return new BreakDetector[][]{processingOrderBreakDetectors, originalOrderedBreakDetectors};
    }
}

