/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.BiFactory;
import org.simpleflatmapper.util.Predicate;

public final class MapperBiFactoryAdapter<S, P>
implements BiFactory<S, MappingContext<? super S>, P> {
    private final Mapper<S, P> mapper;
    private final Predicate<S> nullChecker;
    private final int valueIndex;

    public MapperBiFactoryAdapter(Mapper<S, P> mapper, Predicate<S> nullChecker, int valueIndex) {
        this.mapper = (Mapper)Asserts.requireNonNull((String)"jdbcMapper", mapper);
        this.nullChecker = (Predicate)Asserts.requireNonNull((String)"nullChecker", nullChecker);
        this.valueIndex = valueIndex;
    }

    public String toString() {
        return "MapperBiFactoryAdapter{jdbcMapper=" + this.mapper + '}';
    }

    public P newInstance(S s, MappingContext<? super S> mappingContext) {
        if (this.nullChecker.test(s)) {
            return null;
        }
        P value = this.mapper.map((S)s, (MappingContext<? super S>)mappingContext);
        if (mappingContext != null) {
            mappingContext.setCurrentValue(this.valueIndex, value);
        }
        return value;
    }
}

