/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.BiFunction;
import org.simpleflatmapper.util.Predicate;

public final class MapperBiFunctionAdapter<S, P>
implements BiFunction<S, MappingContext<? super S>, P> {
    private final Mapper<S, P> mapper;
    private final Predicate<S> nullChecker;
    private final int valueIndex;

    public MapperBiFunctionAdapter(Mapper<S, P> mapper, Predicate<S> nullChecker, int valueIndex) {
        this.mapper = (Mapper)Asserts.requireNonNull((String)"jdbcMapper", mapper);
        this.nullChecker = (Predicate)Asserts.requireNonNull((String)"nullChecker", nullChecker);
        this.valueIndex = valueIndex;
    }

    public String toString() {
        return "MapperBiFunctionAdapter{jdbcMapper=" + this.mapper + '}';
    }

    public P apply(S s, MappingContext<? super S> mappingContext) {
        if (this.nullChecker.test(s)) {
            return null;
        }
        P value = this.mapper.map((S)s, (MappingContext<? super S>)mappingContext);
        if (mappingContext != null) {
            mappingContext.setCurrentValue(this.valueIndex, value);
        }
        return value;
    }
}

