/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.context.Key;
import org.simpleflatmapper.map.context.KeyDefinition;
import org.simpleflatmapper.map.context.impl.KeyObjectStore;

public class BreakDetector<S> {
    private final KeyDefinition<S, ?> definition;
    private final KeyObjectStore cache;
    private Key currentKey;

    public BreakDetector(KeyDefinition<S, ?> definition) {
        this.definition = BreakDetector.emptyToNull(definition);
        this.cache = this.definition == null ? null : new KeyObjectStore();
    }

    private static <S> KeyDefinition<S, ?> emptyToNull(KeyDefinition<S, ?> definition) {
        if (definition != null && definition.isEmpty()) {
            return null;
        }
        return definition;
    }

    public boolean broke(S source) throws MappingException {
        if (this.definition == null) {
            return true;
        }
        Key oldKey = this.currentKey;
        this.currentKey = this.definition.getValues(source);
        return oldKey == null || !oldKey.equals(this.currentKey);
    }

    public void handleSource(S source) throws MappingException {
        if (this.definition == null) {
            return;
        }
        this.currentKey = this.definition.getValues(source);
    }

    public void setValue(Object value) {
        if (this.definition != null) {
            if (this.currentKey == null) {
                throw new IllegalStateException("Invalid state currentKey is null");
            }
            this.cache.put(this.currentKey, value);
        }
    }

    public Object getValue() {
        if (this.definition != null) {
            if (this.currentKey == null) {
                throw new IllegalStateException("Invalid state currentKey is null");
            }
            return this.cache.get(this.currentKey);
        }
        return null;
    }

    public void markRootAsBroken() {
        if (this.definition != null) {
            this.currentKey = null;
            this.cache.clear();
        }
    }

    public boolean isRoot() {
        return this.definition != null && this.definition.isRoot();
    }
}

