/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.setter;

import com.datastax.driver.core.SettableByIndexData;
import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.reflect.Setter;

public class MapWithConverterSettableDataSetter<KI, KO, VI, VO>
implements Setter<SettableByIndexData<?>, Map<KI, VI>> {
    private final int index;
    private final ContextualConverter<KI, KO> keyConverter;
    private final ContextualConverter<VI, VO> valueConverter;

    public MapWithConverterSettableDataSetter(int index, ContextualConverter<KI, KO> keyConverter, ContextualConverter<VI, VO> valueConverter) {
        this.index = index;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    public void set(SettableByIndexData<?> target, Map<KI, VI> value) throws Exception {
        if (value == null) {
            target.setToNull(this.index);
        } else {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Map.Entry<KI, VI> e : value.entrySet()) {
                map.put(this.keyConverter.convert(e.getKey(), null), this.valueConverter.convert(e.getValue(), null));
            }
            target.setMap(this.index, map);
        }
    }
}

