/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.converter.EmptyContextFactoryBuilder;
import org.simpleflatmapper.datastax.DataTypeHelper;
import org.simpleflatmapper.datastax.DatastaxColumnKey;
import org.simpleflatmapper.datastax.impl.setter.BigDecimalSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.BigIntegerSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.ByteSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.ConverterToTupleValueMapper;
import org.simpleflatmapper.datastax.impl.setter.ConverterToUDTValueMapper;
import org.simpleflatmapper.datastax.impl.setter.DateSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.DoubleSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.FloatSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.InetAddressSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.IntSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.ListSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.ListWithConverterSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.LongSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.MapSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.MapWithConverterSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.OrdinalEnumSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.SetSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.SetWithConverterSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.ShortSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.StringEnumSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.StringSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.TimeSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.TimestampSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.TupleValueSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.UDTObjectSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.UDTValueSettableDataSetter;
import org.simpleflatmapper.datastax.impl.setter.UUIDSettableDataSetter;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.SetterFactory;
import org.simpleflatmapper.reflect.setter.ConvertDelegateSetter;
import org.simpleflatmapper.util.TypeHelper;

public class SettableDataSetterFactory
implements SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>> {
    private final Map<Class<?>, SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>> factoryPerClass = new HashMap();
    private final MapperConfig<DatastaxColumnKey, ?> mapperConfig;
    private final ReflectionService reflectionService;

    public SettableDataSetterFactory(MapperConfig<DatastaxColumnKey, ?> mapperConfig, ReflectionService reflectionService) {
        this.factoryPerClass.put(Short.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new ShortSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Short.class, this.factoryPerClass.get(Short.TYPE));
        this.factoryPerClass.put(Byte.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new ByteSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Byte.class, this.factoryPerClass.get(Byte.TYPE));
        this.factoryPerClass.put(Integer.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new IntSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Integer.class, this.factoryPerClass.get(Integer.TYPE));
        this.factoryPerClass.put(Long.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                if (((DatastaxColumnKey)arg.getColumnKey()).getDataType() == DataType.time()) {
                    return new TimeSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
                }
                return new LongSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Long.class, this.factoryPerClass.get(Long.TYPE));
        this.factoryPerClass.put(Float.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new FloatSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Float.class, this.factoryPerClass.get(Float.TYPE));
        this.factoryPerClass.put(Double.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new DoubleSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Double.class, this.factoryPerClass.get(Double.TYPE));
        this.factoryPerClass.put(String.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new StringSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Date.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new TimestampSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(UUID.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new UUIDSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(BigDecimal.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new BigDecimalSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(BigInteger.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new BigIntegerSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(InetAddress.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new InetAddressSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(TupleValue.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new TupleValueSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(LocalDate.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
                return new DateSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.mapperConfig = mapperConfig;
        this.reflectionService = reflectionService;
    }

    public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey> arg) {
        Type type;
        Object setter = null;
        Type propertyType = arg.getPropertyMeta().getPropertyType();
        DataType dataType = ((DatastaxColumnKey)arg.getColumnKey()).getDataType();
        Class<?> clazz = type = dataType != null ? DataTypeHelper.asJavaClass(dataType) : null;
        if (type == null) {
            type = propertyType;
        }
        if (TypeHelper.isEnum((Type)propertyType)) {
            if (TypeHelper.areEquals(type, String.class)) {
                return new StringEnumSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
            return new OrdinalEnumSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
        }
        SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey>> setterFactory = this.factoryPerClass.get(TypeHelper.toClass(type));
        EmptyContextFactoryBuilder contextFactoryBuilder = EmptyContextFactoryBuilder.INSTANCE;
        if (setterFactory != null) {
            setter = setterFactory.getSetter(arg);
            if (!TypeHelper.areEquals((Type)TypeHelper.toBoxedClass(type), (Type)TypeHelper.toBoxedClass((Type)propertyType))) {
                ContextualConverter<?, ?> converter = this.getConverter(propertyType, TypeHelper.toClass(type), dataType, arg.getColumnDefinition(), (ContextFactoryBuilder)contextFactoryBuilder);
                setter = converter != null ? new ConvertDelegateSetter(setter, converter) : null;
            }
        }
        if (setter == null && dataType != null) {
            DataType dataTypeElt;
            if (dataType instanceof UserType) {
                setter = propertyType.equals(UDTValue.class) ? new UDTValueSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex()) : UDTObjectSettableDataSetter.newInstance(propertyType, (UserType)dataType, ((DatastaxColumnKey)arg.getColumnKey()).getIndex(), this.mapperConfig, this.reflectionService);
            } else if (TypeHelper.isAssignable(List.class, type) && TypeHelper.isAssignable(List.class, (Type)propertyType)) {
                dataTypeElt = (DataType)dataType.getTypeArguments().get(0);
                Class<?> dEltType = DataTypeHelper.asJavaClass(dataTypeElt);
                Type lEltType = TypeHelper.getComponentTypeOfListOrArray((Type)propertyType);
                if (TypeHelper.areEquals((Type)lEltType, dEltType)) {
                    setter = new ListSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
                } else {
                    ContextualConverter<?, ?> converter = this.getConverter(lEltType, dEltType, dataTypeElt, arg.getColumnDefinition(), (ContextFactoryBuilder)contextFactoryBuilder);
                    if (converter != null) {
                        setter = new ListWithConverterSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex(), converter);
                    }
                }
            } else if (TypeHelper.isAssignable(Set.class, type) && TypeHelper.isAssignable(Set.class, (Type)propertyType)) {
                dataTypeElt = (DataType)dataType.getTypeArguments().get(0);
                Class<?> dEltType = DataTypeHelper.asJavaClass(dataTypeElt);
                Type lEltType = TypeHelper.getComponentTypeOfListOrArray((Type)propertyType);
                if (TypeHelper.areEquals((Type)lEltType, dEltType)) {
                    setter = new SetSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
                } else {
                    ContextualConverter<?, ?> converter = this.getConverter(lEltType, dEltType, dataTypeElt, arg.getColumnDefinition(), (ContextFactoryBuilder)contextFactoryBuilder);
                    if (converter != null) {
                        setter = new SetWithConverterSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex(), converter);
                    }
                }
            } else if (TypeHelper.isAssignable(Map.class, type) && TypeHelper.isAssignable(Map.class, (Type)propertyType)) {
                DataType dtKeyType = (DataType)dataType.getTypeArguments().get(0);
                DataType dtValueType = (DataType)dataType.getTypeArguments().get(1);
                TypeHelper.MapEntryTypes keyValueTypeOfMap = TypeHelper.getKeyValueTypeOfMap((Type)propertyType);
                setter = this.areSame(dtKeyType, keyValueTypeOfMap.getKeyType()) && this.areSame(dtValueType, keyValueTypeOfMap.getValueType()) ? new MapSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex()) : new MapWithConverterSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex(), this.getConverter(keyValueTypeOfMap.getKeyType(), DataTypeHelper.asJavaClass(dtKeyType), dtKeyType, arg.getColumnDefinition(), (ContextFactoryBuilder)contextFactoryBuilder), this.getConverter(keyValueTypeOfMap.getValueType(), DataTypeHelper.asJavaClass(dtValueType), dtValueType, arg.getColumnDefinition(), (ContextFactoryBuilder)contextFactoryBuilder));
            }
        }
        return setter;
    }

    private boolean areSame(DataType dtKeyType, Type element0) {
        return TypeHelper.areEquals((Type)element0, DataTypeHelper.asJavaClass(dtKeyType));
    }

    private ContextualConverter<?, ?> getConverter(Type elementType, Class<?> dataTypeElt, DataType dtElt, ColumnDefinition<DatastaxColumnKey, ?> columnDefinition, ContextFactoryBuilder contextFactoryBuilder) {
        if (dtElt != null) {
            if (UDTValue.class.equals(dataTypeElt)) {
                FieldMapper mapper = UDTObjectSettableDataSetter.newUDTMapper(elementType, (UserType)dtElt, this.mapperConfig, this.reflectionService);
                return new ConverterToUDTValueMapper(mapper, (UserType)dtElt);
            }
            if (TupleValue.class.equals(dataTypeElt)) {
                FieldMapper mapper = TupleValueSettableDataSetter.newTupleMapper(elementType, (TupleType)dtElt, this.mapperConfig, this.reflectionService);
                return new ConverterToTupleValueMapper(mapper, (TupleType)dtElt);
            }
        }
        return ConverterService.getInstance().findConverter(TypeHelper.toClass((Type)elementType), dataTypeElt, contextFactoryBuilder, columnDefinition.properties());
    }
}

