/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.simpleflatmapper.reflect.meta.AliasProvider;
import org.simpleflatmapper.reflect.meta.Table;
import org.simpleflatmapper.util.ErrorHelper;

public class DatastaxAliasProvider
implements AliasProvider {
    private final Class<? extends Annotation> columnClass;
    private final Method columnName;
    private final Class<? extends Annotation> tableClass;
    private final Method tableName;
    private final Method tableKeyspace;

    public DatastaxAliasProvider() {
        try {
            this.columnClass = Class.forName("com.datastax.driver.mapping.annotations.Column");
            this.columnName = this.columnClass.getDeclaredMethod("name", new Class[0]);
            this.tableClass = Class.forName("com.datastax.driver.mapping.annotations.Table");
            this.tableName = this.tableClass.getDeclaredMethod("name", new Class[0]);
            this.tableKeyspace = this.tableClass.getDeclaredMethod("keyspace", new Class[0]);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            throw new Error();
        }
    }

    private String getColumnName(Object col) {
        return this.getString(col, this.columnName);
    }

    private String getTableName(Object col) {
        return this.getString(col, this.tableName);
    }

    private String getTableKeyspace(Object col) {
        return this.getString(col, this.tableKeyspace);
    }

    private String getString(Object col, Method method) {
        try {
            return (String)method.invoke(col, new Object[0]);
        }
        catch (Exception e) {
            return (String)ErrorHelper.rethrow((Throwable)e);
        }
    }

    public Table getTable(Class<?> target) {
        Table keyspaceTable = Table.NULL;
        Annotation table = target.getAnnotation(this.tableClass);
        if (table != null) {
            keyspaceTable = new Table(null, this.getTableKeyspace(table), this.getTableName(table));
        }
        return keyspaceTable;
    }

    public String getAliasForMethod(Method method) {
        String alias = null;
        Annotation col = method.getAnnotation(this.columnClass);
        if (col != null) {
            alias = this.getColumnName(col);
        }
        return alias;
    }

    public String getAliasForField(Field field) {
        String alias = null;
        Annotation col = field.getAnnotation(this.columnClass);
        if (col != null) {
            alias = this.getColumnName(col);
        }
        return alias;
    }
}

