/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.converter.EmptyContextFactoryBuilder;
import org.simpleflatmapper.datastax.DataTypeHelper;
import org.simpleflatmapper.datastax.DatastaxColumnKey;
import org.simpleflatmapper.datastax.DatastaxMapperFactory;
import org.simpleflatmapper.datastax.impl.ConverterMapper;
import org.simpleflatmapper.datastax.impl.getter.DatastaxBigDecimalGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxBigIntegerGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxBooleanGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxByteGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxDateGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxDoubleGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxFloatGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxGenericBigDecimalGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxGenericBigIntegerGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxGenericByteGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxGenericDoubleGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxGenericFloatGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxGenericIntegerGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxGenericLongGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxGenericShortGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxInetAddressGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxIntegerGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxListGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxListWithConverterGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxLongGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxMapGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxMapWithConverterGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxObjectGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxSetGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxSetWithConverterGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxShortGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxStringGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxTimeGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxTimestampGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxToStringGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxTupleGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxTupleValueGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxUDTGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxUUIDFromStringGetter;
import org.simpleflatmapper.datastax.impl.getter.DatastaxUUIDGetter;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.getter.EnumUnspecifiedTypeGetter;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.getter.GetterFactoryRegistry;
import org.simpleflatmapper.reflect.getter.OrdinalEnumGetter;
import org.simpleflatmapper.reflect.getter.StringEnumGetter;
import org.simpleflatmapper.reflect.primitive.IntGetter;
import org.simpleflatmapper.util.TupleHelper;
import org.simpleflatmapper.util.TypeHelper;

public class RowGetterFactory
implements GetterFactory<GettableByIndexData, DatastaxColumnKey> {
    private final GetterFactoryRegistry<GettableByIndexData, DatastaxColumnKey> getterFactories = new GetterFactoryRegistry();
    private final DatastaxMapperFactory datastaxMapperFactory;

    public RowGetterFactory(DatastaxMapperFactory datastaxMapperFactory) {
        this.datastaxMapperFactory = datastaxMapperFactory;
        GetterFactory<GettableByIndexData, DatastaxColumnKey> dateGetterFactory = new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                return new DatastaxTimestampGetter(key.getIndex());
            }
        };
        this.getterFactories.put(Byte.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                Class<?> javaClass;
                Class<?> clazz = javaClass = key.getDataType() != null ? DataTypeHelper.asJavaClass(key.getDataType()) : null;
                if (javaClass == null || javaClass.equals(Byte.class)) {
                    return new DatastaxByteGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericByteGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.mapFromTo(Byte.TYPE, Byte.class);
        this.getterFactories.put(Short.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                Class<?> javaClass;
                Class<?> clazz = javaClass = key.getDataType() != null ? DataTypeHelper.asJavaClass(key.getDataType()) : null;
                if (javaClass == null || javaClass.equals(Short.class)) {
                    return new DatastaxShortGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericShortGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.mapFromTo(Short.TYPE, Short.class);
        this.getterFactories.put(Integer.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                Class<?> javaClass;
                Class<?> clazz = javaClass = key.getDataType() != null ? DataTypeHelper.asJavaClass(key.getDataType()) : null;
                if (javaClass == null || javaClass.equals(Integer.class)) {
                    return new DatastaxIntegerGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericIntegerGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.mapFromTo(Integer.TYPE, Integer.class);
        this.getterFactories.put(Long.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                Class<?> javaClass;
                Class<?> clazz = javaClass = key.getDataType() != null ? DataTypeHelper.asJavaClass(key.getDataType()) : null;
                if (key.getDataType() == DataType.time()) {
                    return new DatastaxTimeGetter(key.getIndex());
                }
                if (javaClass == null || javaClass.equals(Long.class)) {
                    return new DatastaxLongGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericLongGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.mapFromTo(Long.TYPE, Long.class);
        this.getterFactories.put(Float.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                Class<?> javaClass;
                Class<?> clazz = javaClass = key.getDataType() != null ? DataTypeHelper.asJavaClass(key.getDataType()) : null;
                if (javaClass == null || javaClass.equals(Float.class)) {
                    return new DatastaxFloatGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericFloatGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.mapFromTo(Float.TYPE, Float.class);
        this.getterFactories.put(Double.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                Class<?> javaClass;
                Class<?> clazz = javaClass = key.getDataType() != null ? DataTypeHelper.asJavaClass(key.getDataType()) : null;
                if (javaClass == null || javaClass.equals(Double.class)) {
                    return new DatastaxDoubleGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericDoubleGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.mapFromTo(Double.TYPE, Double.class);
        this.getterFactories.put(BigInteger.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                Class<?> javaClass;
                Class<?> clazz = javaClass = key.getDataType() != null ? DataTypeHelper.asJavaClass(key.getDataType()) : null;
                if (javaClass == null || javaClass.equals(BigInteger.class)) {
                    return new DatastaxBigIntegerGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericBigIntegerGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.put(BigDecimal.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                Class<?> javaClass;
                Class<?> clazz = javaClass = key.getDataType() != null ? DataTypeHelper.asJavaClass(key.getDataType()) : null;
                if (javaClass == null || javaClass.equals(BigDecimal.class)) {
                    return new DatastaxBigDecimalGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericBigDecimalGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.put(String.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                if (key.getDataType() == null || String.class.equals(DataTypeHelper.asJavaClass(key.getDataType()))) {
                    return new DatastaxStringGetter(key.getIndex());
                }
                Getter getter = RowGetterFactory.this.newGetter(DataTypeHelper.asJavaClass(key.getDataType()), key, properties);
                if (getter != null) {
                    return new DatastaxToStringGetter(getter);
                }
                return null;
            }
        });
        this.getterFactories.put(UUID.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                if (key.getDataType() == null || UUID.class.equals(DataTypeHelper.asJavaClass(key.getDataType()))) {
                    return new DatastaxUUIDGetter(key.getIndex());
                }
                if (String.class.equals(DataTypeHelper.asJavaClass(key.getDataType()))) {
                    return new DatastaxUUIDFromStringGetter(key.getIndex());
                }
                return null;
            }
        });
        this.getterFactories.put(LocalDate.class, (GetterFactory)new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
                return new DatastaxDateGetter(key.getIndex());
            }
        });
    }

    public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, Object ... properties) {
        Object getter;
        Class targetClass = TypeHelper.toClass((Type)target);
        if (Date.class.equals((Object)targetClass)) {
            return new DatastaxTimestampGetter(key.getIndex());
        }
        if (Boolean.TYPE.equals(targetClass) || Boolean.class.equals((Object)targetClass)) {
            return new DatastaxBooleanGetter(key.getIndex());
        }
        if (InetAddress.class.equals((Object)targetClass)) {
            return new DatastaxInetAddressGetter(key.getIndex());
        }
        if (TupleValue.class.equals((Object)targetClass)) {
            return new DatastaxTupleValueGetter(key.getIndex());
        }
        if (Collection.class.isAssignableFrom(targetClass)) {
            Type elementType = TypeHelper.getComponentTypeOfListOrArray((Type)target);
            Class dataTypeClass = Object.class;
            Class<?> dataTypeElt = null;
            DataType dtElt = null;
            if (key.getDataType() != null) {
                DataType dataType = key.getDataType();
                dataTypeClass = DataTypeHelper.asJavaClass(dataType);
                if (dataType.isCollection()) {
                    dtElt = (DataType)key.getDataType().getTypeArguments().get(0);
                    dataTypeElt = DataTypeHelper.asJavaClass(dtElt);
                }
            } else {
                dataTypeElt = TypeHelper.toClass((Type)elementType);
            }
            if (dataTypeElt != null) {
                if (TypeHelper.areEquals((Type)elementType, (Type)dataTypeElt)) {
                    if (Set.class.equals(dataTypeClass) && targetClass.isAssignableFrom(dataTypeClass)) {
                        return new DatastaxSetGetter(key.getIndex(), TypeHelper.toClass((Type)elementType));
                    }
                    if (List.class.equals(dataTypeClass) && targetClass.isAssignableFrom(dataTypeClass)) {
                        return new DatastaxListGetter(key.getIndex(), TypeHelper.toClass((Type)elementType));
                    }
                } else {
                    ContextualConverter<?, ?> converter = this.getConverter(elementType, dataTypeElt, dtElt);
                    if (converter != null) {
                        if (Set.class.equals(dataTypeClass) && targetClass.isAssignableFrom(dataTypeClass)) {
                            return new DatastaxSetWithConverterGetter(key.getIndex(), dataTypeElt, converter);
                        }
                        if (List.class.equals(dataTypeClass) && targetClass.isAssignableFrom(dataTypeClass)) {
                            return new DatastaxListWithConverterGetter(key.getIndex(), dataTypeElt, converter);
                        }
                    }
                }
            }
        }
        if (Map.class.equals((Object)targetClass)) {
            TypeHelper.MapEntryTypes keyValueTypeOfMap = TypeHelper.getKeyValueTypeOfMap((Type)target);
            Class<?> dtKeyType = null;
            Class<?> dtValueType = null;
            DataType dtKey = null;
            DataType dtValue = null;
            if (key.getDataType() != null) {
                List typeArguments = key.getDataType().getTypeArguments();
                if (typeArguments.size() == 2) {
                    dtKey = (DataType)typeArguments.get(0);
                    dtKeyType = DataTypeHelper.asJavaClass(dtKey);
                    dtValue = (DataType)typeArguments.get(1);
                    dtValueType = DataTypeHelper.asJavaClass(dtValue);
                }
            } else {
                dtKeyType = TypeHelper.toClass((Type)keyValueTypeOfMap.getKeyType());
                dtValueType = TypeHelper.toClass((Type)keyValueTypeOfMap.getValueType());
            }
            if (dtKeyType != null && dtValueType != null) {
                if (TypeHelper.areEquals((Type)keyValueTypeOfMap.getKeyType(), dtKeyType) && TypeHelper.areEquals((Type)keyValueTypeOfMap.getValueType(), (Type)dtValueType)) {
                    return new DatastaxMapGetter(key.getIndex(), TypeHelper.toClass((Type)keyValueTypeOfMap.getKeyType()), TypeHelper.toClass((Type)keyValueTypeOfMap.getValueType()));
                }
                ContextualConverter<?, ?> keyConverter = this.getConverter(keyValueTypeOfMap.getKeyType(), dtKeyType, dtKey);
                ContextualConverter<?, ?> valueConverter = this.getConverter(keyValueTypeOfMap.getValueType(), dtValueType, dtValue);
                if (keyConverter != null && valueConverter != null) {
                    return new DatastaxMapWithConverterGetter(key.getIndex(), dtKeyType, dtValueType, keyConverter, valueConverter);
                }
            }
        }
        if (TupleHelper.isTuple((Type)target) && key.getDataType() != null && key.getDataType() instanceof TupleType) {
            TupleType tt = (TupleType)key.getDataType();
            List typeArguments = tt.getTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = targetClass.getTypeParameters();
            if (typeArguments.size() <= typeParameters.length) {
                return DatastaxTupleGetter.newInstance(this.datastaxMapperFactory, target, tt, key.getIndex());
            }
        }
        if (TypeHelper.isEnum((Type)target) && (getter = this.enumGetter(key, TypeHelper.toClass((Type)target))) != null) {
            return getter;
        }
        if (key.getDataType() != null && key.getDataType() instanceof UserType) {
            UserType ut = (UserType)key.getDataType();
            return DatastaxUDTGetter.newInstance(this.datastaxMapperFactory, target, ut, key.getIndex());
        }
        getter = this.getterFromFactories(target, key, properties);
        if (getter != null) {
            return getter;
        }
        return null;
    }

    private <P> Getter<GettableByIndexData, P> getterFromFactories(Type target, DatastaxColumnKey key, Object[] properties) {
        Getter getter;
        GetterFactory rowGetterFactory = this.getterFactories.findFactoryFor(target);
        if (rowGetterFactory != null && (getter = rowGetterFactory.newGetter(target, (Object)key, properties)) != null) {
            return getter;
        }
        return null;
    }

    private ContextualConverter<?, ?> getConverter(Type elementType, Class<?> dataTypeElt, DataType dtElt) {
        if (dtElt != null) {
            if (UDTValue.class.equals(dataTypeElt)) {
                return new ConverterMapper(DatastaxUDTGetter.newUDTMapper(elementType, (UserType)dtElt, this.datastaxMapperFactory));
            }
            if (TupleValue.class.equals(dataTypeElt)) {
                return new ConverterMapper(DatastaxTupleGetter.newTupleMapper(elementType, (TupleType)dtElt, this.datastaxMapperFactory));
            }
        }
        return ConverterService.getInstance().findConverter(dataTypeElt, elementType, (ContextFactoryBuilder)EmptyContextFactoryBuilder.INSTANCE, new Object[0]);
    }

    public <E extends Enum<E>> Getter<GettableByIndexData, E> enumGetter(DatastaxColumnKey key, Class<?> enumClass) {
        if (key.getDataType() != null) {
            Class<?> javaClass;
            Class<?> clazz = javaClass = key.getDataType() != null ? DataTypeHelper.asJavaClass(key.getDataType()) : null;
            if (Number.class.isAssignableFrom(javaClass)) {
                return new OrdinalEnumGetter((IntGetter)new DatastaxIntegerGetter(key.getIndex()), enumClass);
            }
            if (String.class.equals(javaClass)) {
                return new StringEnumGetter((Getter)new DatastaxStringGetter(key.getIndex()), enumClass);
            }
        } else {
            return new EnumUnspecifiedTypeGetter((Getter)new DatastaxObjectGetter(key.getIndex()), enumClass);
        }
        return null;
    }
}

