/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.DatastaxMapperFactory;
import org.sfm.datastax.impl.ConverterMapper;
import org.sfm.datastax.impl.getter.DatastaxBigDecimalGetter;
import org.sfm.datastax.impl.getter.DatastaxBigIntegerGetter;
import org.sfm.datastax.impl.getter.DatastaxBooleanGetter;
import org.sfm.datastax.impl.getter.DatastaxDateGetter;
import org.sfm.datastax.impl.getter.DatastaxDoubleGetter;
import org.sfm.datastax.impl.getter.DatastaxFloatGetter;
import org.sfm.datastax.impl.getter.DatastaxGenericBigDecimalGetter;
import org.sfm.datastax.impl.getter.DatastaxGenericBigIntegerGetter;
import org.sfm.datastax.impl.getter.DatastaxGenericDoubleGetter;
import org.sfm.datastax.impl.getter.DatastaxGenericFloatGetter;
import org.sfm.datastax.impl.getter.DatastaxGenericIntegerGetter;
import org.sfm.datastax.impl.getter.DatastaxGenericLongGetter;
import org.sfm.datastax.impl.getter.DatastaxGenericShortGetter;
import org.sfm.datastax.impl.getter.DatastaxInetAddressGetter;
import org.sfm.datastax.impl.getter.DatastaxIntegerGetter;
import org.sfm.datastax.impl.getter.DatastaxListGetter;
import org.sfm.datastax.impl.getter.DatastaxListWithConverterGetter;
import org.sfm.datastax.impl.getter.DatastaxLongGetter;
import org.sfm.datastax.impl.getter.DatastaxMapGetter;
import org.sfm.datastax.impl.getter.DatastaxMapWithConverterGetter;
import org.sfm.datastax.impl.getter.DatastaxObjectGetter;
import org.sfm.datastax.impl.getter.DatastaxSetGetter;
import org.sfm.datastax.impl.getter.DatastaxSetWithConverterGetter;
import org.sfm.datastax.impl.getter.DatastaxStringGetter;
import org.sfm.datastax.impl.getter.DatastaxToStringGetter;
import org.sfm.datastax.impl.getter.DatastaxTupleGetter;
import org.sfm.datastax.impl.getter.DatastaxTupleValueGetter;
import org.sfm.datastax.impl.getter.DatastaxUDTGetter;
import org.sfm.datastax.impl.getter.DatastaxUUIDFromStringGetter;
import org.sfm.datastax.impl.getter.DatastaxUUIDGetter;
import org.sfm.map.FieldKey;
import org.sfm.map.GetterFactory;
import org.sfm.map.getter.EnumUnspecifiedTypeGetter;
import org.sfm.map.getter.OrdinalEnumGetter;
import org.sfm.map.getter.StringEnumGetter;
import org.sfm.map.getter.joda.JodaTimeGetterFactory;
import org.sfm.map.getter.time.JavaTimeGetterFactory;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.reflect.Getter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.primitive.IntGetter;
import org.sfm.tuples.Tuple2;
import org.sfm.tuples.Tuples;
import org.sfm.utils.conv.Converter;
import org.sfm.utils.conv.ConverterFactory;

public class RowGetterFactory
implements GetterFactory<GettableByIndexData, DatastaxColumnKey> {
    private final HashMap<Class<?>, GetterFactory<GettableByIndexData, DatastaxColumnKey>> getterFactories = new HashMap();
    private final DatastaxMapperFactory datastaxMapperFactory;
    private JodaTimeGetterFactory<GettableByIndexData, DatastaxColumnKey> jodaTimeGetterFactory;

    public RowGetterFactory(DatastaxMapperFactory datastaxMapperFactory) {
        this.datastaxMapperFactory = datastaxMapperFactory;
        GetterFactory<GettableByIndexData, DatastaxColumnKey> dateGetterFactory = new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new DatastaxDateGetter(key.getIndex());
            }
        };
        JavaTimeGetterFactory javaTimeGetterFactory = new JavaTimeGetterFactory((GetterFactory)dateGetterFactory);
        this.getterFactories.put(LocalDate.class, (GetterFactory<GettableByIndexData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(LocalDateTime.class, (GetterFactory<GettableByIndexData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(LocalTime.class, (GetterFactory<GettableByIndexData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(OffsetDateTime.class, (GetterFactory<GettableByIndexData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(OffsetTime.class, (GetterFactory<GettableByIndexData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(ZonedDateTime.class, (GetterFactory<GettableByIndexData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(Instant.class, (GetterFactory<GettableByIndexData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(Year.class, (GetterFactory<GettableByIndexData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(YearMonth.class, (GetterFactory<GettableByIndexData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.jodaTimeGetterFactory = new JodaTimeGetterFactory((GetterFactory)dateGetterFactory);
        this.getterFactories.put(Short.class, new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDataType() != null ? key.getDataType().asJavaClass() : null;
                if (javaClass != null && Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericShortGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.put(Short.TYPE, this.getterFactories.get(Short.class));
        this.getterFactories.put(Integer.class, new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDataType() != null ? key.getDataType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(Integer.class)) {
                    return new DatastaxIntegerGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericIntegerGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.put(Integer.TYPE, this.getterFactories.get(Integer.class));
        this.getterFactories.put(Long.class, new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDataType() != null ? key.getDataType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(Long.class)) {
                    return new DatastaxLongGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericLongGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.put(Long.TYPE, this.getterFactories.get(Long.class));
        this.getterFactories.put(Float.class, new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDataType() != null ? key.getDataType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(Float.class)) {
                    return new DatastaxFloatGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericFloatGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.put(Float.TYPE, this.getterFactories.get(Float.class));
        this.getterFactories.put(Double.class, new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDataType() != null ? key.getDataType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(Double.class)) {
                    return new DatastaxDoubleGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericDoubleGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.put(Double.TYPE, this.getterFactories.get(Double.class));
        this.getterFactories.put(BigInteger.class, new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDataType() != null ? key.getDataType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(BigInteger.class)) {
                    return new DatastaxBigIntegerGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericBigIntegerGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.put(BigDecimal.class, new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDataType() != null ? key.getDataType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(BigDecimal.class)) {
                    return new DatastaxBigDecimalGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericBigDecimalGetter(key.getIndex(), key.getDataType());
                }
                return null;
            }
        });
        this.getterFactories.put(String.class, new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                if (key.getDataType() == null || String.class.equals((Object)key.getDataType().asJavaClass())) {
                    return new DatastaxStringGetter(key.getIndex());
                }
                Getter getter = RowGetterFactory.this.newGetter((Type)key.getDataType().asJavaClass(), key, columnDefinition);
                if (getter != null) {
                    return new DatastaxToStringGetter(getter);
                }
                return null;
            }
        });
        this.getterFactories.put(UUID.class, new GetterFactory<GettableByIndexData, DatastaxColumnKey>(){

            public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                if (key.getDataType() == null || UUID.class.equals((Object)key.getDataType().asJavaClass())) {
                    return new DatastaxUUIDGetter(key.getIndex());
                }
                if (String.class.equals((Object)key.getDataType().asJavaClass())) {
                    return new DatastaxUUIDFromStringGetter(key.getIndex());
                }
                return null;
            }
        });
    }

    public <P> Getter<GettableByIndexData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
        Getter getter;
        Class targetClass = TypeHelper.toClass((Type)target);
        if (Date.class.equals((Object)targetClass)) {
            return new DatastaxDateGetter(key.getIndex());
        }
        if (Boolean.TYPE.equals(targetClass) || Boolean.class.equals((Object)targetClass)) {
            return new DatastaxBooleanGetter(key.getIndex());
        }
        if (InetAddress.class.equals((Object)targetClass)) {
            return new DatastaxInetAddressGetter(key.getIndex());
        }
        if (TupleValue.class.equals((Object)targetClass)) {
            return new DatastaxTupleValueGetter(key.getIndex());
        }
        if (Collection.class.isAssignableFrom(targetClass)) {
            Type elementType = TypeHelper.getComponentTypeOfListOrArray((Type)target);
            Class dataTypeClass = Object.class;
            Class dataTypeElt = null;
            DataType dtElt = null;
            if (key.getDataType() != null) {
                DataType dataType = key.getDataType();
                dataTypeClass = dataType.asJavaClass();
                if (dataType.isCollection()) {
                    dtElt = (DataType)key.getDataType().getTypeArguments().get(0);
                    dataTypeElt = dtElt.asJavaClass();
                }
            } else {
                dataTypeElt = TypeHelper.toClass((Type)elementType);
            }
            if (dataTypeElt != null) {
                if (TypeHelper.areEquals((Type)elementType, (Class)dataTypeElt)) {
                    if (Set.class.equals((Object)dataTypeClass) && targetClass.isAssignableFrom(dataTypeClass)) {
                        return new DatastaxSetGetter(key.getIndex(), TypeHelper.toClass((Type)elementType));
                    }
                    if (List.class.equals((Object)dataTypeClass) && targetClass.isAssignableFrom(dataTypeClass)) {
                        return new DatastaxListGetter(key.getIndex(), TypeHelper.toClass((Type)elementType));
                    }
                } else {
                    Converter<?, ?> converter = this.getConverter(elementType, dataTypeElt, dtElt);
                    if (converter != null) {
                        if (Set.class.equals((Object)dataTypeClass) && targetClass.isAssignableFrom(dataTypeClass)) {
                            return new DatastaxSetWithConverterGetter(key.getIndex(), dataTypeElt, converter);
                        }
                        if (List.class.equals((Object)dataTypeClass) && targetClass.isAssignableFrom(dataTypeClass)) {
                            return new DatastaxListWithConverterGetter(key.getIndex(), dataTypeElt, converter);
                        }
                    }
                }
            }
        }
        if (Map.class.equals((Object)targetClass)) {
            Tuple2 keyValueTypeOfMap = TypeHelper.getKeyValueTypeOfMap((Type)target);
            Class dtKeyType = null;
            Class dtValueType = null;
            DataType dtKey = null;
            DataType dtValue = null;
            if (key.getDataType() != null) {
                List typeArguments = key.getDataType().getTypeArguments();
                if (typeArguments.size() == 2) {
                    dtKey = (DataType)typeArguments.get(0);
                    dtKeyType = dtKey.asJavaClass();
                    dtValue = (DataType)typeArguments.get(1);
                    dtValueType = dtValue.asJavaClass();
                }
            } else {
                dtKeyType = TypeHelper.toClass((Type)((Type)keyValueTypeOfMap.first()));
                dtValueType = TypeHelper.toClass((Type)((Type)keyValueTypeOfMap.second()));
            }
            if (dtKeyType != null && dtValueType != null) {
                if (TypeHelper.areEquals((Type)((Type)keyValueTypeOfMap.first()), (Class)dtKeyType) && TypeHelper.areEquals((Type)((Type)keyValueTypeOfMap.second()), (Class)dtValueType)) {
                    return new DatastaxMapGetter(key.getIndex(), TypeHelper.toClass((Type)((Type)keyValueTypeOfMap.first())), TypeHelper.toClass((Type)((Type)keyValueTypeOfMap.second())));
                }
                Converter<?, ?> keyConverter = this.getConverter((Type)keyValueTypeOfMap.first(), dtKeyType, dtKey);
                Converter<?, ?> valueConverter = this.getConverter((Type)keyValueTypeOfMap.second(), dtValueType, dtValue);
                if (keyConverter != null && valueConverter != null) {
                    return new DatastaxMapWithConverterGetter(key.getIndex(), dtKeyType, dtValueType, keyConverter, valueConverter);
                }
            }
        }
        if (Tuples.isTuple((Type)target) && key.getDataType() != null && key.getDataType() instanceof TupleType) {
            TupleType tt = (TupleType)key.getDataType();
            List typeArguments = tt.getTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = targetClass.getTypeParameters();
            if (typeArguments.size() <= typeParameters.length) {
                return DatastaxTupleGetter.newInstance(this.datastaxMapperFactory, target, tt, key.getIndex());
            }
        }
        if (TypeHelper.isEnum((Type)target) && (getter = this.enumGetter(key, TypeHelper.toClass((Type)target))) != null) {
            return getter;
        }
        GetterFactory<GettableByIndexData, DatastaxColumnKey> rowGetterFactory = this.getterFactories.get(targetClass);
        if (rowGetterFactory != null) {
            return rowGetterFactory.newGetter(target, (FieldKey)key, columnDefinition);
        }
        Getter getter2 = this.jodaTimeGetterFactory.newGetter(target, (FieldKey)key, columnDefinition);
        if (getter2 != null) {
            return getter2;
        }
        if (key.getDataType() != null && key.getDataType() instanceof UserType) {
            UserType ut = (UserType)key.getDataType();
            return DatastaxUDTGetter.newInstance(this.datastaxMapperFactory, target, ut, key.getIndex());
        }
        return null;
    }

    private Converter<?, ?> getConverter(Type elementType, Class<?> dataTypeElt, DataType dtElt) {
        if (dtElt != null) {
            if (UDTValue.class.equals(dataTypeElt)) {
                return new ConverterMapper(DatastaxUDTGetter.newUDTMapper(elementType, (UserType)dtElt, this.datastaxMapperFactory));
            }
            if (TupleValue.class.equals(dataTypeElt)) {
                return new ConverterMapper(DatastaxTupleGetter.newTupleMapper(elementType, (TupleType)dtElt, this.datastaxMapperFactory));
            }
        }
        return ConverterFactory.getConverter(dataTypeElt, (Type)elementType, (Object[])new Object[0]);
    }

    public <E extends Enum<E>> Getter<GettableByIndexData, E> enumGetter(DatastaxColumnKey key, Class<?> enumClass) {
        if (key.getDataType() != null) {
            Class javaClass;
            Class clazz = javaClass = key.getDataType() != null ? key.getDataType().asJavaClass() : null;
            if (Number.class.isAssignableFrom(javaClass)) {
                return new OrdinalEnumGetter((IntGetter)new DatastaxIntegerGetter(key.getIndex()), enumClass);
            }
            if (String.class.equals((Object)javaClass)) {
                return new StringEnumGetter((Getter)new DatastaxStringGetter(key.getIndex()), enumClass);
            }
        } else {
            return new EnumUnspecifiedTypeGetter((Getter)new DatastaxObjectGetter(key.getIndex()), enumClass);
        }
        return null;
    }
}

