/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.lang.reflect.Type;
import java.util.List;
import org.sfm.datastax.BoundStatementMapper;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.DatastaxCrud;
import org.sfm.datastax.DatastaxMapper;
import org.sfm.datastax.DatastaxMapperBuilder;
import org.sfm.datastax.DatastaxMapperFactory;
import org.sfm.datastax.SettableDataMapperBuilder;
import org.sfm.map.column.ColumnProperty;

public class DatastaxCrudFactory {
    public static <T, K> DatastaxCrud<T, K> newInstance(Type target, Type keyTarget, TableMetadata tableMetadata, Session session, DatastaxMapperFactory datastaxMapperFactory) {
        DatastaxMapperFactory mapperFactory = DatastaxMapperFactory.newInstance(datastaxMapperFactory);
        return DatastaxCrudFactory.createCrud(target, keyTarget, tableMetadata, session, mapperFactory);
    }

    private static <T, K> DatastaxCrud<T, K> createCrud(Type target, Type keyTarget, TableMetadata tableMetadata, Session session, DatastaxMapperFactory mapperFactory) {
        DatastaxMapper<T> selectMapper = DatastaxCrudFactory.selectMapper(target, tableMetadata, mapperFactory);
        return new DatastaxCrud<T, K>(session.prepare(DatastaxCrudFactory.insertQuery(tableMetadata, new String[0])), session.prepare(DatastaxCrudFactory.insertQuery(tableMetadata, "TTL", "TIMESTAMP")), session.prepare(DatastaxCrudFactory.insertQuery(tableMetadata, "TTL")), session.prepare(DatastaxCrudFactory.insertQuery(tableMetadata, "TIMESTAMP")), session.prepare(DatastaxCrudFactory.readQuery(tableMetadata)), session.prepare(DatastaxCrudFactory.deleteQuery(tableMetadata)), session.prepare(DatastaxCrudFactory.deleteQueryWithTimestamp(tableMetadata)), DatastaxCrudFactory.insertSetter(target, tableMetadata, mapperFactory, 0), DatastaxCrudFactory.keySetter(keyTarget, tableMetadata, mapperFactory, 0), DatastaxCrudFactory.keySetter(keyTarget, tableMetadata, mapperFactory, 1), selectMapper, tableMetadata.getColumns().size(), session);
    }

    private static String deleteQuery(TableMetadata tableMetadata) {
        Delete delete = QueryBuilder.delete().from(tableMetadata);
        Delete.Where where = delete.where();
        List columns = tableMetadata.getPrimaryKey();
        for (ColumnMetadata column : columns) {
            where.and(QueryBuilder.eq((String)column.getName(), (Object)QueryBuilder.bindMarker()));
        }
        return delete.toString();
    }

    private static String deleteQueryWithTimestamp(TableMetadata tableMetadata) {
        Delete delete = QueryBuilder.delete().from(tableMetadata);
        delete.using(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker()));
        Delete.Where where = delete.where();
        List columns = tableMetadata.getPrimaryKey();
        for (ColumnMetadata column : columns) {
            where.and(QueryBuilder.eq((String)column.getName(), (Object)QueryBuilder.bindMarker()));
        }
        return delete.toString();
    }

    private static String readQuery(TableMetadata tableMetadata) {
        Select.Selection select = QueryBuilder.select();
        List columns = tableMetadata.getColumns();
        for (ColumnMetadata column : columns) {
            select.column(column.getName());
        }
        Select.Where where = select.from(tableMetadata).where();
        columns = tableMetadata.getPrimaryKey();
        for (ColumnMetadata column : columns) {
            where.and(QueryBuilder.eq((String)column.getName(), (Object)QueryBuilder.bindMarker()));
        }
        return where.toString();
    }

    private static String insertQuery(TableMetadata tableMetadata, String ... options) {
        Insert insert = QueryBuilder.insertInto((TableMetadata)tableMetadata);
        if (options != null) {
            Insert.Options using = insert.using();
            for (String option : options) {
                if ("TTL".equals(option)) {
                    using.and(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker()));
                    continue;
                }
                using.and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker()));
            }
        }
        List columns = tableMetadata.getColumns();
        for (ColumnMetadata column : columns) {
            insert.value(column.getName(), (Object)QueryBuilder.bindMarker());
        }
        return insert.toString();
    }

    private static <T> DatastaxMapper<T> selectMapper(Type target, TableMetadata tableMetadata, DatastaxMapperFactory mapperFactory) {
        DatastaxMapperBuilder mapperBuilder = mapperFactory.newBuilder(target);
        int i = 0;
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            mapperBuilder.addMapping(DatastaxColumnKey.of(columnMetadata, i++), new ColumnProperty[0]);
        }
        return (DatastaxMapper)mapperBuilder.mapper();
    }

    private static <K> BoundStatementMapper<K> keySetter(Type keyTarget, TableMetadata tableMetadata, DatastaxMapperFactory mapperFactory, int offset) {
        SettableDataMapperBuilder mapperBuilder = mapperFactory.newBuilderFrom(keyTarget);
        int i = offset;
        for (ColumnMetadata columnMetadata : tableMetadata.getPrimaryKey()) {
            mapperBuilder.addColumn(DatastaxColumnKey.of(columnMetadata, i++), new ColumnProperty[0]);
        }
        return new BoundStatementMapper(mapperBuilder.mapper());
    }

    private static <T> BoundStatementMapper<T> insertSetter(Type target, TableMetadata tableMetadata, DatastaxMapperFactory mapperFactory, int offset) {
        SettableDataMapperBuilder mapperBuilder = mapperFactory.newBuilderFrom(target);
        int i = offset;
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            mapperBuilder.addColumn(DatastaxColumnKey.of(columnMetadata, i++), new ColumnProperty[0]);
        }
        return new BoundStatementMapper(mapperBuilder.mapper());
    }
}

