/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl;

import com.datastax.driver.core.GettableByIndexData;
import java.util.ArrayList;
import java.util.List;
import org.sfm.reflect.Getter;
import org.sfm.utils.conv.Converter;

public class DatastaxListWithConverterGetter<I, T>
implements Getter<GettableByIndexData, List<T>> {
    private final int index;
    private final Class<I> type;
    private final Converter<I, T> converter;

    public DatastaxListWithConverterGetter(int index, Class<I> type, Converter<I, T> converter) {
        this.index = index;
        this.type = type;
        this.converter = converter;
    }

    public List<T> get(GettableByIndexData target) throws Exception {
        List list = target.getList(this.index, this.type);
        if (list == null) {
            return null;
        }
        ArrayList<Object> convertedList = new ArrayList<Object>(list.size());
        for (Object i : list) {
            convertedList.add(this.converter.convert(i));
        }
        return convertedList;
    }
}

