/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import org.sfm.datastax.DataHelper;
import org.sfm.datastax.DataTypeHelper;
import org.sfm.reflect.Getter;
import org.sfm.reflect.primitive.DoubleGetter;

public class DatastaxGenericDoubleGetter
implements DoubleGetter<GettableByIndexData>,
Getter<GettableByIndexData, Double> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericDoubleGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        DataType.Name name = dataType.getName();
        if (DataTypeHelper.isNumber(name)) {
            return name;
        }
        throw new IllegalArgumentException("Datatype " + dataType + " not a number");
    }

    public Double get(GettableByIndexData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        return this.getDouble(target);
    }

    public double getDouble(GettableByIndexData target) throws Exception {
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return target.getLong(this.index);
            }
            case VARINT: {
                return target.getVarint(this.index).doubleValue();
            }
            case INT: {
                return target.getInt(this.index);
            }
            case DECIMAL: {
                return target.getDecimal(this.index).doubleValue();
            }
            case FLOAT: {
                return target.getFloat(this.index);
            }
            case DOUBLE: {
                return target.getDouble(this.index);
            }
        }
        if (DataTypeHelper.isSmallInt(this.dataTypeName)) {
            return DataHelper.getShort(this.index, target);
        }
        if (DataTypeHelper.isTinyInt(this.dataTypeName)) {
            return DataHelper.getByte(this.index, target);
        }
        if (DataTypeHelper.isTime(this.dataTypeName)) {
            return DataHelper.getTime(this.index, target);
        }
        return 0.0;
    }
}

