/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.getter;

import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.UserType;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.DatastaxMapperBuilder;
import org.sfm.datastax.DatastaxMapperFactory;
import org.sfm.datastax.impl.DatastaxMappingContextFactoryBuilder;
import org.sfm.datastax.impl.RowGetterFactory;
import org.sfm.map.FieldKey;
import org.sfm.map.GetterFactory;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.context.MappingContextFactoryBuilder;
import org.sfm.map.mapper.FieldMapperMapperBuilder;
import org.sfm.map.mapper.MapperSource;
import org.sfm.map.mapper.MapperSourceImpl;
import org.sfm.reflect.Getter;
import org.sfm.reflect.meta.ClassMeta;

public class DatastaxUDTGetter<T>
implements Getter<GettableByIndexData, T> {
    private final Mapper<GettableByIndexData, T> mapper;
    private final int index;

    public DatastaxUDTGetter(Mapper<GettableByIndexData, T> mapper, int index) {
        this.mapper = mapper;
        this.index = index;
    }

    public T get(GettableByIndexData target) throws Exception {
        return (T)this.mapper.map((Object)target.getUDTValue(this.index));
    }

    public static <P> Getter<GettableByIndexData, P> newInstance(DatastaxMapperFactory factory, Type target, UserType tt, int index) {
        Mapper<GettableByIndexData, P> mapper = DatastaxUDTGetter.newUDTMapper(target, tt, factory);
        return new DatastaxUDTGetter<P>(mapper, index);
    }

    public static <P> Mapper<GettableByIndexData, P> newUDTMapper(Type target, UserType tt, DatastaxMapperFactory factory) {
        FieldMapperMapperBuilder<GettableByIndexData, P, DatastaxColumnKey> builder = DatastaxUDTGetter.newFieldMapperBuilder(factory, target);
        Iterator iterator = tt.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            UserType.Field f = (UserType.Field)iterator.next();
            FieldMapperColumnDefinition identity = FieldMapperColumnDefinition.identity();
            builder.addMapping((FieldKey)new DatastaxColumnKey(f.getName(), i, f.getType()), identity);
            ++i;
        }
        return builder.mapper();
    }

    public static <P> FieldMapperMapperBuilder<GettableByIndexData, P, DatastaxColumnKey> newFieldMapperBuilder(DatastaxMapperFactory factory, Type target) {
        MapperConfig config = factory.mapperConfig();
        MapperSourceImpl mapperSource = new MapperSourceImpl(GettableByIndexData.class, (GetterFactory)new RowGetterFactory(factory));
        ClassMeta classMeta = factory.getClassMeta(target);
        return new FieldMapperMapperBuilder((MapperSource)mapperSource, classMeta, config, (MappingContextFactoryBuilder)new DatastaxMappingContextFactoryBuilder(), DatastaxMapperBuilder.KEY_FACTORY);
    }
}

