/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.sfm.datastax.DataTypeHelper;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.impl.setter.BigDecimalSettableDataSetter;
import org.sfm.datastax.impl.setter.BigIntegerSettableDataSetter;
import org.sfm.datastax.impl.setter.ByteSettableDataSetter;
import org.sfm.datastax.impl.setter.ConverterToTupleValueMapper;
import org.sfm.datastax.impl.setter.ConverterToUDTValueMapper;
import org.sfm.datastax.impl.setter.DateSettableDataSetter;
import org.sfm.datastax.impl.setter.DoubleSettableDataSetter;
import org.sfm.datastax.impl.setter.FloatSettableDataSetter;
import org.sfm.datastax.impl.setter.InetAddressSettableDataSetter;
import org.sfm.datastax.impl.setter.IntSettableDataSetter;
import org.sfm.datastax.impl.setter.ListSettableDataSetter;
import org.sfm.datastax.impl.setter.ListWithConverterSettableDataSetter;
import org.sfm.datastax.impl.setter.LongSettableDataSetter;
import org.sfm.datastax.impl.setter.MapSettableDataSetter;
import org.sfm.datastax.impl.setter.MapWithConverterSettableDataSetter;
import org.sfm.datastax.impl.setter.OrdinalEnumSettableDataSetter;
import org.sfm.datastax.impl.setter.SetSettableDataSetter;
import org.sfm.datastax.impl.setter.SetWithConverterSettableDataSetter;
import org.sfm.datastax.impl.setter.ShortSettableDataSetter;
import org.sfm.datastax.impl.setter.StringEnumSettableDataSetter;
import org.sfm.datastax.impl.setter.StringSettableDataSetter;
import org.sfm.datastax.impl.setter.TimeSettableDataSetter;
import org.sfm.datastax.impl.setter.TimestampSettableDataSetter;
import org.sfm.datastax.impl.setter.TupleValueSettableDataSetter;
import org.sfm.datastax.impl.setter.UDTObjectSettableDataSetter;
import org.sfm.datastax.impl.setter.UDTValueSettableDataSetter;
import org.sfm.datastax.impl.setter.UUIDSettableDataSetter;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.map.setter.ConvertDelegateSetter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.SetterFactory;
import org.sfm.reflect.TypeHelper;
import org.sfm.tuples.Tuple2;
import org.sfm.utils.conv.Converter;
import org.sfm.utils.conv.ConverterFactory;

public class SettableDataSetterFactory
implements SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>> {
    private final Map<Class<?>, SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>> factoryPerClass = new HashMap();
    private final MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> mapperConfig;
    private final ReflectionService reflectionService;

    public SettableDataSetterFactory(MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> mapperConfig, ReflectionService reflectionService) {
        this.factoryPerClass.put(Short.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new ShortSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Short.class, this.factoryPerClass.get(Short.TYPE));
        this.factoryPerClass.put(Byte.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new ByteSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Byte.class, this.factoryPerClass.get(Byte.TYPE));
        this.factoryPerClass.put(Integer.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new IntSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Integer.class, this.factoryPerClass.get(Integer.TYPE));
        this.factoryPerClass.put(Long.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                if (DataTypeHelper.isTime(((DatastaxColumnKey)arg.getColumnKey()).getDataType().getName())) {
                    return new TimeSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
                }
                return new LongSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Long.class, this.factoryPerClass.get(Long.TYPE));
        this.factoryPerClass.put(Float.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new FloatSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Float.class, this.factoryPerClass.get(Float.TYPE));
        this.factoryPerClass.put(Double.TYPE, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new DoubleSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Double.class, this.factoryPerClass.get(Double.TYPE));
        this.factoryPerClass.put(String.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new StringSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(Date.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new TimestampSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(UUID.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new UUIDSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(BigDecimal.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new BigDecimalSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(BigInteger.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new BigIntegerSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(InetAddress.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new InetAddressSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        this.factoryPerClass.put(TupleValue.class, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

            public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                return new TupleValueSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
        });
        if (DataTypeHelper.localDateClass != null) {
            this.factoryPerClass.put(DataTypeHelper.localDateClass, new SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>>(){

                public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
                    return new DateSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
                }
            });
        }
        this.mapperConfig = mapperConfig;
        this.reflectionService = reflectionService;
    }

    public <P> Setter<SettableByIndexData, P> getSetter(PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>> arg) {
        Type type;
        Object setter = null;
        Type propertyType = arg.getPropertyMeta().getPropertyType();
        DataType dataType = ((DatastaxColumnKey)arg.getColumnKey()).getDataType();
        Class<?> clazz = type = dataType != null ? DataTypeHelper.asJavaClass(dataType) : null;
        if (type == null) {
            type = propertyType;
        }
        if (TypeHelper.isEnum((Type)propertyType)) {
            if (TypeHelper.isClass(type, String.class)) {
                return new StringEnumSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
            }
            return new OrdinalEnumSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
        }
        SetterFactory<SettableByIndexData, PropertyMapping<?, ?, DatastaxColumnKey, ? extends ColumnDefinition<DatastaxColumnKey, ?>>> setterFactory = this.factoryPerClass.get(TypeHelper.toClass(type));
        if (setterFactory != null) {
            setter = setterFactory.getSetter(arg);
            if (!TypeHelper.areEquals((Type)TypeHelper.toBoxedClass(type), (Class)TypeHelper.toBoxedClass((Type)propertyType))) {
                Converter<?, ?> converter = this.getConverter(propertyType, TypeHelper.toClass(type), dataType, arg.getColumnDefinition());
                setter = converter != null ? new ConvertDelegateSetter(setter, converter) : null;
            }
        }
        if (setter == null && dataType != null) {
            DataType dataTypeElt;
            if (dataType instanceof UserType) {
                setter = propertyType.equals(UDTValue.class) ? new UDTValueSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex()) : UDTObjectSettableDataSetter.newInstance(propertyType, (UserType)dataType, ((DatastaxColumnKey)arg.getColumnKey()).getIndex(), this.mapperConfig, this.reflectionService);
            } else if (TypeHelper.isAssignable(List.class, type) && TypeHelper.isAssignable(List.class, (Type)propertyType)) {
                dataTypeElt = (DataType)dataType.getTypeArguments().get(0);
                Class<?> dEltType = DataTypeHelper.asJavaClass(dataTypeElt);
                Type lEltType = TypeHelper.getComponentTypeOfListOrArray((Type)propertyType);
                if (TypeHelper.areEquals((Type)lEltType, dEltType)) {
                    setter = new ListSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
                } else {
                    Converter<?, ?> converter = this.getConverter(lEltType, dEltType, dataTypeElt, arg.getColumnDefinition());
                    if (converter != null) {
                        setter = new ListWithConverterSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex(), converter);
                    }
                }
            } else if (TypeHelper.isAssignable(Set.class, type) && TypeHelper.isAssignable(Set.class, (Type)propertyType)) {
                dataTypeElt = (DataType)dataType.getTypeArguments().get(0);
                Class<?> dEltType = DataTypeHelper.asJavaClass(dataTypeElt);
                Type lEltType = TypeHelper.getComponentTypeOfListOrArray((Type)propertyType);
                if (TypeHelper.areEquals((Type)lEltType, dEltType)) {
                    setter = new SetSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex());
                } else {
                    Converter<?, ?> converter = this.getConverter(lEltType, dEltType, dataTypeElt, arg.getColumnDefinition());
                    if (converter != null) {
                        setter = new SetWithConverterSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex(), converter);
                    }
                }
            } else if (TypeHelper.isAssignable(Map.class, type) && TypeHelper.isAssignable(Map.class, (Type)propertyType)) {
                DataType dtKeyType = (DataType)dataType.getTypeArguments().get(0);
                DataType dtValueType = (DataType)dataType.getTypeArguments().get(1);
                Tuple2 keyValueTypeOfMap = TypeHelper.getKeyValueTypeOfMap((Type)propertyType);
                setter = this.areSame(dtKeyType, (Type)keyValueTypeOfMap.getElement0()) && this.areSame(dtValueType, (Type)keyValueTypeOfMap.getElement1()) ? new MapSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex()) : new MapWithConverterSettableDataSetter(((DatastaxColumnKey)arg.getColumnKey()).getIndex(), this.getConverter((Type)keyValueTypeOfMap.getElement0(), DataTypeHelper.asJavaClass(dtKeyType), dtKeyType, arg.getColumnDefinition()), this.getConverter((Type)keyValueTypeOfMap.getElement1(), DataTypeHelper.asJavaClass(dtValueType), dtValueType, arg.getColumnDefinition()));
            }
        }
        return setter;
    }

    private boolean areSame(DataType dtKeyType, Type element0) {
        return TypeHelper.areEquals((Type)element0, DataTypeHelper.asJavaClass(dtKeyType));
    }

    private Converter<?, ?> getConverter(Type elementType, Class<?> dataTypeElt, DataType dtElt, ColumnDefinition<DatastaxColumnKey, ?> columnDefinition) {
        if (dtElt != null) {
            if (UDTValue.class.equals(dataTypeElt)) {
                Mapper mapper = UDTObjectSettableDataSetter.newUDTMapper(elementType, (UserType)dtElt, this.mapperConfig, this.reflectionService);
                return new ConverterToUDTValueMapper(mapper, (UserType)dtElt);
            }
            if (TupleValue.class.equals(dataTypeElt)) {
                Mapper mapper = TupleValueSettableDataSetter.newTupleMapper(elementType, (TupleType)dtElt, this.mapperConfig, this.reflectionService);
                return new ConverterToTupleValueMapper(mapper, (TupleType)dtElt);
            }
        }
        return ConverterFactory.getConverter((Class)TypeHelper.toClass((Type)elementType), dataTypeElt, (Object[])new Object[]{columnDefinition});
    }
}

