/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl;

import com.datastax.driver.core.GettableData;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.impl.DatastaxBigDecimalGetter;
import org.sfm.datastax.impl.DatastaxBigIntegerGetter;
import org.sfm.datastax.impl.DatastaxBooleanGetter;
import org.sfm.datastax.impl.DatastaxDateGetter;
import org.sfm.datastax.impl.DatastaxDoubleGetter;
import org.sfm.datastax.impl.DatastaxFloatGetter;
import org.sfm.datastax.impl.DatastaxGenericBigDecimalGetter;
import org.sfm.datastax.impl.DatastaxGenericBigIntegerGetter;
import org.sfm.datastax.impl.DatastaxGenericDoubleGetter;
import org.sfm.datastax.impl.DatastaxGenericFloatGetter;
import org.sfm.datastax.impl.DatastaxGenericIntegerGetter;
import org.sfm.datastax.impl.DatastaxGenericLongGetter;
import org.sfm.datastax.impl.DatastaxGenericShortGetter;
import org.sfm.datastax.impl.DatastaxInetAddressGetter;
import org.sfm.datastax.impl.DatastaxIntegerGetter;
import org.sfm.datastax.impl.DatastaxLongGetter;
import org.sfm.datastax.impl.DatastaxObjectGetter;
import org.sfm.datastax.impl.DatastaxStringGetter;
import org.sfm.datastax.impl.DatastaxUUIDGetter;
import org.sfm.map.FieldKey;
import org.sfm.map.GetterFactory;
import org.sfm.map.getter.EnumUnspecifiedTypeGetter;
import org.sfm.map.getter.OrdinalEnumGetter;
import org.sfm.map.getter.StringEnumGetter;
import org.sfm.map.getter.joda.JodaTimeGetterFactory;
import org.sfm.map.getter.time.JavaTimeGetterFactory;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.reflect.Getter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.primitive.IntGetter;

public class RowGetterFactory
implements GetterFactory<GettableData, DatastaxColumnKey> {
    private final HashMap<Class<?>, GetterFactory<GettableData, DatastaxColumnKey>> getterFactories = new HashMap();
    private final GetterFactory<GettableData, DatastaxColumnKey> dateGetterFactory = new GetterFactory<GettableData, DatastaxColumnKey>(){

        public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
            return new DatastaxDateGetter(key.getIndex());
        }
    };
    private JodaTimeGetterFactory<GettableData, DatastaxColumnKey> jodaTimeGetterFactory;

    public RowGetterFactory() {
        JavaTimeGetterFactory javaTimeGetterFactory = new JavaTimeGetterFactory(this.dateGetterFactory);
        this.getterFactories.put(LocalDate.class, (GetterFactory<GettableData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(LocalDateTime.class, (GetterFactory<GettableData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(LocalTime.class, (GetterFactory<GettableData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(OffsetDateTime.class, (GetterFactory<GettableData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(OffsetTime.class, (GetterFactory<GettableData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(ZonedDateTime.class, (GetterFactory<GettableData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(Instant.class, (GetterFactory<GettableData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(Year.class, (GetterFactory<GettableData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.getterFactories.put(YearMonth.class, (GetterFactory<GettableData, DatastaxColumnKey>)javaTimeGetterFactory);
        this.jodaTimeGetterFactory = new JodaTimeGetterFactory(this.dateGetterFactory);
        this.getterFactories.put(Short.class, new GetterFactory<GettableData, DatastaxColumnKey>(){

            public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDateType() != null ? key.getDateType().asJavaClass() : null;
                if (javaClass != null && Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericShortGetter(key.getIndex(), key.getDateType());
                }
                return null;
            }
        });
        this.getterFactories.put(Short.TYPE, this.getterFactories.get(Short.class));
        this.getterFactories.put(Integer.class, new GetterFactory<GettableData, DatastaxColumnKey>(){

            public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDateType() != null ? key.getDateType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(Integer.class)) {
                    return new DatastaxIntegerGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericIntegerGetter(key.getIndex(), key.getDateType());
                }
                return null;
            }
        });
        this.getterFactories.put(Integer.TYPE, this.getterFactories.get(Integer.class));
        this.getterFactories.put(Long.class, new GetterFactory<GettableData, DatastaxColumnKey>(){

            public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDateType() != null ? key.getDateType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(Long.class)) {
                    return new DatastaxLongGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericLongGetter(key.getIndex(), key.getDateType());
                }
                return null;
            }
        });
        this.getterFactories.put(Long.TYPE, this.getterFactories.get(Long.class));
        this.getterFactories.put(Float.class, new GetterFactory<GettableData, DatastaxColumnKey>(){

            public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDateType() != null ? key.getDateType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(Float.class)) {
                    return new DatastaxFloatGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericFloatGetter(key.getIndex(), key.getDateType());
                }
                return null;
            }
        });
        this.getterFactories.put(Float.TYPE, this.getterFactories.get(Float.class));
        this.getterFactories.put(Double.class, new GetterFactory<GettableData, DatastaxColumnKey>(){

            public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDateType() != null ? key.getDateType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(Double.class)) {
                    return new DatastaxDoubleGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericDoubleGetter(key.getIndex(), key.getDateType());
                }
                return null;
            }
        });
        this.getterFactories.put(Double.TYPE, this.getterFactories.get(Double.class));
        this.getterFactories.put(BigInteger.class, new GetterFactory<GettableData, DatastaxColumnKey>(){

            public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDateType() != null ? key.getDateType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(BigInteger.class)) {
                    return new DatastaxBigIntegerGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericBigIntegerGetter(key.getIndex(), key.getDateType());
                }
                return null;
            }
        });
        this.getterFactories.put(BigDecimal.class, new GetterFactory<GettableData, DatastaxColumnKey>(){

            public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                Class javaClass;
                Class clazz = javaClass = key.getDateType() != null ? key.getDateType().asJavaClass() : null;
                if (javaClass == null || javaClass.equals(BigDecimal.class)) {
                    return new DatastaxBigDecimalGetter(key.getIndex());
                }
                if (Number.class.isAssignableFrom(javaClass)) {
                    return new DatastaxGenericBigDecimalGetter(key.getIndex(), key.getDateType());
                }
                return null;
            }
        });
    }

    public <P> Getter<GettableData, P> newGetter(Type target, DatastaxColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
        Getter getter;
        Class targetClass = TypeHelper.toClass((Type)target);
        if (String.class.equals((Object)targetClass)) {
            return new DatastaxStringGetter(key.getIndex());
        }
        if (Date.class.equals((Object)targetClass)) {
            return new DatastaxDateGetter(key.getIndex());
        }
        if (Boolean.TYPE.equals(targetClass) || Boolean.class.equals((Object)targetClass)) {
            return new DatastaxBooleanGetter(key.getIndex());
        }
        if (UUID.class.equals((Object)targetClass)) {
            return new DatastaxUUIDGetter(key.getIndex());
        }
        if (InetAddress.class.equals((Object)targetClass)) {
            return new DatastaxInetAddressGetter(key.getIndex());
        }
        if (TypeHelper.isEnum((Type)target) && (getter = this.enumGetter(key, TypeHelper.toClass((Type)target))) != null) {
            return getter;
        }
        GetterFactory<GettableData, DatastaxColumnKey> rowGetterFactory = this.getterFactories.get(targetClass);
        if (rowGetterFactory != null) {
            return rowGetterFactory.newGetter(target, (FieldKey)key, columnDefinition);
        }
        Getter getter2 = this.jodaTimeGetterFactory.newGetter(target, (FieldKey)key, columnDefinition);
        if (getter2 != null) {
            return getter2;
        }
        return null;
    }

    public <E extends Enum<E>> Getter<GettableData, E> enumGetter(DatastaxColumnKey key, Class<?> enumClass) {
        if (key.getDateType() != null) {
            Class javaClass;
            Class clazz = javaClass = key.getDateType() != null ? key.getDateType().asJavaClass() : null;
            if (Number.class.isAssignableFrom(javaClass)) {
                return new OrdinalEnumGetter((IntGetter)new DatastaxIntegerGetter(key.getIndex()), enumClass);
            }
            if (String.class.equals((Object)javaClass)) {
                return new StringEnumGetter((Getter)new DatastaxStringGetter(key.getIndex()), enumClass);
            }
        } else {
            return new EnumUnspecifiedTypeGetter((Getter)new DatastaxObjectGetter(key.getIndex()), enumClass);
        }
        return null;
    }
}

