/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import org.simpleflatmapper.csv.parser.BufferOverflowException;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.TextFormat;

public class CharConsumer {
    private static final int DATA = 16;
    private static final int ESCAPED = 8;
    private static final int LAST_CHAR_WAS_SEPARATOR = 4;
    private static final int LAST_CHAR_WAS_CR = 2;
    private static final int ESCAPED_AREA = 1;
    private static final int NONE = 0;
    private static final int TURN_OFF_LAST_CHAR_MASK = -7;
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char SPACE = ' ';
    private final CharBuffer csvBuffer;
    private final TextFormat textFormat;
    private final CellPreProcessor cellPreProcessor;
    private int _currentIndex = 0;
    private int _currentState = 0;

    public CharConsumer(CharBuffer csvBuffer, TextFormat textFormat, CellPreProcessor cellPreProcessor) {
        this.csvBuffer = csvBuffer;
        this.cellPreProcessor = cellPreProcessor;
        this.textFormat = textFormat;
    }

    public final void consumeAllBuffer(CellConsumer cellConsumer) {
        int currentIndex;
        boolean notIgnoreLeadingSpace = !this.cellPreProcessor.ignoreLeadingSpace();
        char escapeChar = this.textFormat.escapeChar;
        char separatorChar = this.textFormat.separatorChar;
        int currentState = this._currentState;
        char[] chars = this.csvBuffer.buffer;
        int bufferSize = this.csvBuffer.bufferSize;
        for (currentIndex = this._currentIndex; currentIndex < bufferSize; ++currentIndex) {
            char character = chars[currentIndex];
            if (character != escapeChar) {
                if ((currentState & 1) == 0) {
                    if (character == separatorChar) {
                        this.newCell(cellConsumer, currentIndex, chars);
                        currentState = 4;
                        continue;
                    }
                    if (character == '\n') {
                        if ((currentState & 2) == 0) {
                            this.endOfRow(cellConsumer, currentIndex, chars);
                        }
                        this.csvBuffer.mark = currentIndex + 1;
                        currentState = 0;
                        continue;
                    }
                    if (character == '\r') {
                        this.endOfRow(cellConsumer, currentIndex, chars);
                        this.csvBuffer.mark = currentIndex + 1;
                        currentState = 2;
                        continue;
                    }
                }
                currentState &= 0xFFFFFFF9;
                if (!notIgnoreLeadingSpace && character == ' ') continue;
                currentState |= 0x10;
                continue;
            }
            if (((currentState ^ 0x10) & 0x18) == 0) continue;
            currentState = currentState ^ 1 | 8;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
    }

    public final boolean consumeToNextRow(CellConsumer cellConsumer) {
        int currentIndex;
        boolean notIgnoreLeadingSpace = !this.cellPreProcessor.ignoreLeadingSpace();
        char escapeChar = this.textFormat.escapeChar;
        char separatorChar = this.textFormat.separatorChar;
        int currentState = this._currentState;
        char[] chars = this.csvBuffer.buffer;
        int bufferSize = this.csvBuffer.bufferSize;
        for (currentIndex = this._currentIndex; currentIndex < bufferSize; ++currentIndex) {
            char character = chars[currentIndex];
            if (character != escapeChar) {
                if ((currentState & 1) == 0) {
                    if (character == separatorChar) {
                        this.newCell(cellConsumer, currentIndex, chars);
                        currentState = 4;
                        continue;
                    }
                    if (character == '\n') {
                        if ((currentState & 2) == 0 && this.bEndOfRow(cellConsumer, currentIndex, chars)) {
                            this.csvBuffer.mark = currentIndex + 1;
                            this._currentIndex = currentIndex + 1;
                            this._currentState = 0;
                            return true;
                        }
                        this.csvBuffer.mark = currentIndex + 1;
                        currentState = 0;
                        continue;
                    }
                    if (character == '\r') {
                        if (this.bEndOfRow(cellConsumer, currentIndex, chars)) {
                            this.csvBuffer.mark = currentIndex + 1;
                            this._currentIndex = currentIndex + 1;
                            this._currentState = 2;
                            return true;
                        }
                        this.csvBuffer.mark = currentIndex + 1;
                        currentState = 2;
                        continue;
                    }
                }
                currentState &= 0xFFFFFFF9;
                if (!notIgnoreLeadingSpace && character == ' ') continue;
                currentState |= 0x10;
                continue;
            }
            if (((currentState ^ 0x10) & 0x18) == 0) continue;
            currentState = currentState ^ 1 | 8;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
        return false;
    }

    public final void finish(CellConsumer cellConsumer) {
        if (this.hasUnconsumedData() || (this._currentState & 4) != 0) {
            this.newCell(cellConsumer, this._currentIndex, this.csvBuffer.buffer);
            this._currentState = 0;
        }
        cellConsumer.end();
    }

    public final boolean refillBuffer() throws IOException {
        return this.csvBuffer.fillBuffer() >= 0;
    }

    public final void shiftBufferToMark() throws BufferOverflowException {
        this._currentIndex -= this.csvBuffer.shiftBufferToMark();
    }

    private void endOfRow(CellConsumer cellConsumer, int currentIndex, char[] chars) {
        this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, currentIndex, cellConsumer);
        cellConsumer.endOfRow();
    }

    private boolean bEndOfRow(CellConsumer cellConsumer, int currentIndex, char[] chars) {
        this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, currentIndex, cellConsumer);
        return cellConsumer.endOfRow();
    }

    private void newCell(CellConsumer cellConsumer, int currentIndex, char[] chars) {
        this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, currentIndex, cellConsumer);
        this.csvBuffer.mark = currentIndex + 1;
    }

    private boolean hasUnconsumedData() {
        return this._currentIndex > this.csvBuffer.mark;
    }
}

