/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.primitive;

import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.impl.cellreader.ByteCellValueReader;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.reflect.primitive.ByteSetter;

public class ByteDelayedCellSetter<T>
implements DelayedCellSetter<T, Byte> {
    private final ByteSetter<? super T> setter;
    private final ByteCellValueReader reader;
    private byte value;
    private boolean isNull;

    public ByteDelayedCellSetter(ByteSetter<? super T> setter, ByteCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    @Override
    public Byte consumeValue() {
        return this.isNull ? null : Byte.valueOf(this.consumeByte());
    }

    @Override
    public Byte peekValue() {
        return this.isNull ? null : Byte.valueOf(this.value);
    }

    public byte consumeByte() {
        byte v = this.value;
        this.value = 0;
        this.isNull = true;
        return v;
    }

    @Override
    public void set(T t) throws Exception {
        this.setter.setByte(t, this.consumeByte());
    }

    @Override
    public boolean isSettable() {
        return this.setter != null;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readByte(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "ByteDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

