/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.primitive;

import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.impl.cellreader.LongCellValueReader;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.reflect.primitive.LongSetter;

public class LongDelayedCellSetter<T>
implements DelayedCellSetter<T, Long> {
    private final LongSetter<? super T> setter;
    private final LongCellValueReader reader;
    private long value;
    private boolean isNull;

    public LongDelayedCellSetter(LongSetter<? super T> setter, LongCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    @Override
    public Long consumeValue() {
        return this.isNull ? null : Long.valueOf(this.consumeLong());
    }

    @Override
    public Long peekValue() {
        return this.isNull ? null : Long.valueOf(this.value);
    }

    public long consumeLong() {
        long v = this.value;
        this.value = 0L;
        this.isNull = true;
        return v;
    }

    @Override
    public void set(T t) throws Exception {
        this.setter.setLong(t, this.consumeLong());
    }

    @Override
    public boolean isSettable() {
        return this.setter != null;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readLong(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "LongDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

