/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;

public class UnescapeCellPreProcessor
extends CellPreProcessor {
    private char escapeChar;
    private char quoteChar;

    public UnescapeCellPreProcessor(char escapeChar, char quoteChar) {
        this.escapeChar = escapeChar;
        this.quoteChar = quoteChar;
    }

    @Override
    public final void newCell(char[] chars, int start, int end, CellConsumer cellConsumer, int state) {
        if ((state & 8) == 0) {
            cellConsumer.newCell(chars, start, end - start);
        } else {
            this.unescape(chars, start + 1, end, cellConsumer);
        }
    }

    private void unescape(char[] chars, int start, int end, CellConsumer cellConsumer) {
        int nextEscapeChar = this.findNextEscapeChar(chars, start, end - 1);
        if (nextEscapeChar == -1) {
            int l = end - start;
            if (l > 0 && chars[end - 1] == this.quoteChar) {
                --l;
            }
            cellConsumer.newCell(chars, start, l);
        } else {
            this.shiftEscapedChar(chars, start, end, cellConsumer, nextEscapeChar);
        }
    }

    private int findNextEscapeChar(char[] chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (chars[i] != this.escapeChar) continue;
            return i;
        }
        return -1;
    }

    private void shiftEscapedChar(char[] chars, int start, int end, CellConsumer cellConsumer, int currentIndex) {
        int destIndex = currentIndex;
        boolean escaped = true;
        for (int i = currentIndex + 1; i < end - 1; ++i) {
            char c = chars[i];
            if (!escaped) {
                if (c != this.escapeChar) {
                    chars[destIndex++] = c;
                    continue;
                }
                escaped = true;
                continue;
            }
            chars[destIndex++] = this.unescapeChar(c);
            escaped = false;
        }
        char c = chars[end - 1];
        if (c != this.quoteChar || escaped) {
            chars[destIndex++] = c;
        }
        cellConsumer.newCell(chars, start, destIndex - start);
    }

    private char unescapeChar(char c) {
        if (this.escapeChar == '\\') {
            switch (c) {
                case 'n': {
                    return '\n';
                }
                case 'r': {
                    return '\r';
                }
                case 't': {
                    return '\t';
                }
                case 'b': {
                    return '\b';
                }
                case 'f': {
                    return '\f';
                }
                case 'v': {
                    return '\u000b';
                }
            }
        }
        return c;
    }

    @Override
    public final boolean ignoreLeadingSpace() {
        return false;
    }
}

