/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.primitive;

import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.impl.cellreader.BooleanCellValueReader;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.reflect.primitive.BooleanSetter;

public class BooleanDelayedCellSetter<T>
implements DelayedCellSetter<T, Boolean> {
    private final BooleanSetter<? super T> setter;
    private final BooleanCellValueReader reader;
    private boolean value;
    private boolean isNull;

    public BooleanDelayedCellSetter(BooleanSetter<? super T> setter, BooleanCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    @Override
    public Boolean consumeValue() {
        return this.isNull ? null : Boolean.valueOf(this.consumeBoolean());
    }

    @Override
    public Boolean peekValue() {
        return this.isNull ? null : Boolean.valueOf(this.value);
    }

    public boolean consumeBoolean() {
        boolean v = this.value;
        this.value = false;
        this.isNull = true;
        return v;
    }

    @Override
    public void set(T t) throws Exception {
        this.setter.setBoolean(t, this.consumeBoolean());
    }

    @Override
    public boolean isSettable() {
        return this.setter != null;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readBoolean(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "BooleanDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

