/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import org.simpleflatmapper.csv.parser.BufferOverflowException;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CharBuffer;

public abstract class CharConsumer {
    private static final int DATA = 16;
    private static final int ESCAPED = 8;
    private static final int LAST_CHAR_WAS_SEPARATOR = 4;
    private static final int LAST_CHAR_WAS_CR = 2;
    private static final int LAST_CHAR_WAS_ESCAPE = 1;
    private static final int NONE = 0;
    private static final int TURN_OFF_LAST_CHAR_MASK = -7;
    private final CharBuffer _csvBuffer;
    private final boolean notIgnoreLeadingSpace;
    private int _currentIndex = 0;
    private int _currentState = 0;

    public CharConsumer(CharBuffer csvBuffer, boolean ignoreLeadingSpace) {
        this._csvBuffer = csvBuffer;
        this.notIgnoreLeadingSpace = !ignoreLeadingSpace;
    }

    public final void consumeAllBuffer(CellConsumer cellConsumer) {
        int currentIndex;
        char[] chars = this._csvBuffer.getCharBuffer();
        int bufferSize = this._csvBuffer.getBufferSize();
        int currentState = this._currentState;
        for (currentIndex = this._currentIndex; currentIndex < bufferSize; ++currentIndex) {
            char character = chars[currentIndex];
            if (this.isNotEscapeCharacter(character)) {
                if (CharConsumer.isCharEscaped(currentState)) {
                    if (this.isSeparator(character)) {
                        this.newCell(chars, currentIndex, cellConsumer);
                        currentState = 4;
                        continue;
                    }
                    if (character == '\n') {
                        if (CharConsumer.lastCharWasNotCr(currentState)) {
                            this.endOfRow(chars, currentIndex, cellConsumer);
                            currentState = 0;
                            continue;
                        }
                        this.startNextCell(currentIndex);
                        currentState = 0;
                        continue;
                    }
                    if (character == '\r') {
                        this.endOfRow(chars, currentIndex, cellConsumer);
                        currentState = 2;
                        continue;
                    }
                }
                currentState &= 0xFFFFFFF9;
                currentState |= this.notIgnoreLeadingSpace || character != ' ' ? 16 : 0;
                continue;
            }
            if (!CharConsumer.canEscaped(currentState)) continue;
            currentState = currentState ^ 1 | 8;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
    }

    public final boolean consumeToNextRow(CellConsumer cellConsumer) {
        int currentIndex;
        char[] chars = this._csvBuffer.getCharBuffer();
        int bufferSize = this._csvBuffer.getBufferSize();
        int currentState = this._currentState;
        for (currentIndex = this._currentIndex; currentIndex < bufferSize; ++currentIndex) {
            char character = chars[currentIndex];
            if (this.isNotEscapeCharacter(character)) {
                if (CharConsumer.isCharEscaped(currentState)) {
                    if (this.isSeparator(character)) {
                        this.newCell(chars, currentIndex, cellConsumer);
                        currentState = 4;
                        continue;
                    }
                    if (character == '\n') {
                        if (CharConsumer.lastCharWasNotCr(currentState)) {
                            if (this.endOfRowReturnValue(chars, currentIndex, cellConsumer)) {
                                this.exitOnState(currentIndex, 0);
                                return true;
                            }
                            currentState = 0;
                            continue;
                        }
                        this.startNextCell(currentIndex);
                        currentState = 0;
                        continue;
                    }
                    if (character == '\r') {
                        if (this.endOfRowReturnValue(chars, currentIndex, cellConsumer)) {
                            this.exitOnState(currentIndex, 2);
                            return true;
                        }
                        currentState = 2;
                        continue;
                    }
                }
                currentState &= 0xFFFFFFF9;
                currentState |= this.notIgnoreLeadingSpace || character != ' ' ? 16 : 0;
                continue;
            }
            if (!CharConsumer.canEscaped(currentState)) continue;
            currentState = currentState ^ 1 | 8;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
        return false;
    }

    public final void finish(CellConsumer cellConsumer) {
        if (this.hasUnconsumedData() || CharConsumer.lastCharWasSeparator(this._currentState)) {
            this.newCell(this._csvBuffer.getCharBuffer(), this._currentIndex, cellConsumer);
            this._currentState = 0;
        }
        cellConsumer.end();
    }

    protected abstract boolean isSeparator(char var1);

    protected abstract boolean isNotEscapeCharacter(char var1);

    protected abstract void pushCell(char[] var1, int var2, int var3, CellConsumer var4);

    public final boolean refillBuffer() throws IOException {
        return this._csvBuffer.fillBuffer() >= 0;
    }

    public final void shiftBufferToMark() throws BufferOverflowException {
        this._currentIndex -= this._csvBuffer.shiftBufferToMark();
    }

    private void endOfRow(char[] chars, int currentIndex, CellConsumer cellConsumer) {
        this.newCell(chars, currentIndex, cellConsumer);
        cellConsumer.endOfRow();
    }

    private boolean endOfRowReturnValue(char[] chars, int currentIndex, CellConsumer cellConsumer) {
        this.newCell(chars, currentIndex, cellConsumer);
        return cellConsumer.endOfRow();
    }

    private void newCell(char[] chars, int currentIndex, CellConsumer cellConsumer) {
        this.pushCell(chars, this._csvBuffer.mark, currentIndex, cellConsumer);
        this.startNextCell(currentIndex);
    }

    private void startNextCell(int currentIndex) {
        this._csvBuffer.mark = currentIndex + 1;
    }

    private boolean hasUnconsumedData() {
        return this._currentIndex > this._csvBuffer.mark;
    }

    private void exitOnState(int currentIndex, int none) {
        this._currentState = none;
        this._currentIndex = currentIndex + 1;
    }

    private static boolean canEscaped(int currentState) {
        return ((currentState ^ 0x10) & 0x18) != 0;
    }

    private static boolean isEscaped(int currentState) {
        return (currentState & 8) != 0;
    }

    private static boolean isCharEscaped(int currentState) {
        return (currentState & 1) == 0;
    }

    private static boolean lastCharWasNotCr(int currentState) {
        return (currentState & 2) == 0;
    }

    private static boolean lastCharWasSeparator(int currentState) {
        return (currentState & 4) != 0;
    }
}

