/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsclient.caller;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.beanutils.PropertyUtils;
import org.simple4j.wsclient.exception.SystemException;
import org.simple4j.wsclient.formatter.IFormatter;
import org.simple4j.wsclient.http.HTTPWSClient;
import org.simple4j.wsclient.http.HTTPWSResponse;
import org.simple4j.wsclient.parser.IParser;
import org.simple4j.wsclient.util.CollectionsPathRetreiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Caller {
    private static Logger logger = LoggerFactory.getLogger(Caller.class);
    private static InetAddress localHost = null;
    private HTTPWSClient httpWSClient;
    private String serviceMethod;
    private Map<String, String> responseBodyToCustomFieldMapping;
    private String httpStatusCodeFieldName = "HTTP_STATUS_CODE";
    private String httpResponseObjectFieldName = "HTTP_RESPONSE_OBJECT";
    private Map<String, List<IFormatter>> requestHeaderFormatters;
    private IFormatter requestBodyFormatter;
    private IFormatter requestURLFormatter;
    private Map<String, IParser> responseBodyParsers;
    private String responseHeaderFieldName = "HTTP_RESPONSE_HEADERS";
    private String requestIdHeaderName = "swsc-reqid";
    private String clientHostHeaderName = "swsc-host";
    private Map<String, List<String>> staticHeaderValues = null;
    private CollectionsPathRetreiver collectionsPathRetreiver = null;

    public String getResponseHeaderFieldName() {
        return this.responseHeaderFieldName;
    }

    public void setResponseHeaderFieldName(String responseHeaderFieldName) {
        this.responseHeaderFieldName = responseHeaderFieldName;
    }

    public Map<String, IParser> getResponseBodyParsers() {
        return this.responseBodyParsers;
    }

    public void setResponseBodyParsers(Map<String, IParser> responseBodyParsers) {
        this.responseBodyParsers = responseBodyParsers;
    }

    public String getRequestIdHeaderName() {
        return this.requestIdHeaderName;
    }

    public void setRequestIdHeaderName(String requestIdHeaderName) {
        this.requestIdHeaderName = requestIdHeaderName;
    }

    public String getClientHostHeaderName() {
        return this.clientHostHeaderName;
    }

    public void setClientHostHeaderName(String clientHostHeaderName) {
        this.clientHostHeaderName = clientHostHeaderName;
    }

    public Map<String, List<String>> getStaticHeaderValues() {
        return this.staticHeaderValues;
    }

    public void setStaticHeaderValues(Map<String, List<String>> staticHeaderValues) {
        this.staticHeaderValues = staticHeaderValues;
    }

    public Map<String, List<IFormatter>> getRequestHeaderFormatters() {
        return this.requestHeaderFormatters;
    }

    public void setRequestHeaderFormatters(Map<String, List<IFormatter>> requestHeaderFormatters) {
        this.requestHeaderFormatters = requestHeaderFormatters;
    }

    public IFormatter getRequestBodyFormatter() {
        return this.requestBodyFormatter;
    }

    public void setRequestBodyFormatter(IFormatter requestBodyFormatter) {
        this.requestBodyFormatter = requestBodyFormatter;
    }

    public IFormatter getRequestURLFormatter() {
        return this.requestURLFormatter;
    }

    public void setRequestURLFormatter(IFormatter requestURLFormatter) {
        this.requestURLFormatter = requestURLFormatter;
    }

    public HTTPWSClient getHttpWSClient() {
        return this.httpWSClient;
    }

    public void setHttpWSClient(HTTPWSClient httpWSClient) {
        this.httpWSClient = httpWSClient;
    }

    public String getServiceMethod() {
        return this.serviceMethod;
    }

    public void setServiceMethod(String serviceMethod) {
        this.serviceMethod = serviceMethod;
    }

    public Map<String, String> getResponseBodyToCustomFieldMapping() {
        return this.responseBodyToCustomFieldMapping;
    }

    public void setResponseBodyToCustomFieldMapping(Map<String, String> responseBodyToCustomFieldMapping) {
        this.responseBodyToCustomFieldMapping = responseBodyToCustomFieldMapping;
    }

    public String getHttpStatusCodeFieldName() {
        return this.httpStatusCodeFieldName;
    }

    public void setHttpStatusCodeFieldName(String httpStatusCodeFieldName) {
        this.httpStatusCodeFieldName = httpStatusCodeFieldName;
    }

    public String getHttpResponseObjectFieldName() {
        return this.httpResponseObjectFieldName;
    }

    public void setHttpResponseObjectFieldName(String httpResponseObjectFieldName) {
        this.httpResponseObjectFieldName = httpResponseObjectFieldName;
    }

    public CollectionsPathRetreiver getCollectionsPathRetreiver() {
        if (this.collectionsPathRetreiver == null) {
            this.collectionsPathRetreiver = new CollectionsPathRetreiver();
        }
        return this.collectionsPathRetreiver;
    }

    public void setCollectionsPathRetreiver(CollectionsPathRetreiver collectionsPathRetreiver) {
        this.collectionsPathRetreiver = collectionsPathRetreiver;
    }

    public Map<String, Object> call(Object requestObject) {
        try {
            HashMap<String, Object> ret = null;
            String serviceURL = this.getRequestURLFormatter().formatData(requestObject);
            logger.info("Finished formatting request URL: " + serviceURL);
            String requestBody = null;
            if (this.getRequestBodyFormatter() != null) {
                requestBody = this.getRequestBodyFormatter().formatData(requestObject);
            }
            logger.info("Finished formatting request body: " + requestBody);
            HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
            if (this.getStaticHeaderValues() != null) {
                requestHeaders.putAll(this.getStaticHeaderValues());
            }
            for (Map.Entry<String, List<IFormatter>> entry : this.getRequestHeaderFormatters().entrySet()) {
                List<IFormatter> formatters = entry.getValue();
                for (IFormatter formatter : formatters) {
                    ArrayList<String> replacedValues = (ArrayList<String>)requestHeaders.get(entry.getKey());
                    if (replacedValues == null) {
                        replacedValues = new ArrayList<String>();
                        requestHeaders.put(entry.getKey(), replacedValues);
                    }
                    replacedValues.add(formatter.formatData(requestObject));
                }
            }
            this.addRequestIdHeader(requestHeaders);
            this.addClientHostnameHeader(requestHeaders);
            HTTPWSResponse response = this.invokeHTTP(serviceURL, requestBody, requestHeaders);
            String responseBodyAsString = response.getResponseBodyAsString();
            ret = new HashMap<String, Object>();
            ret.put(this.getHttpStatusCodeFieldName(), "" + response.getStatusCode());
            ret.put(this.getHttpResponseObjectFieldName(), responseBodyAsString);
            if (this.getResponseBodyParsers() != null && this.getResponseBodyParsers().size() > 0) {
                for (Map.Entry<String, IParser> entry : this.getResponseBodyParsers().entrySet()) {
                    if (!("" + response.getStatusCode()).matches(entry.getKey())) continue;
                    Map<String, ? extends Object> parseDataMap = entry.getValue().parseData(responseBodyAsString);
                    ret.put(this.getHttpResponseObjectFieldName(), parseDataMap);
                    Map<String, Object> objectsFromResponseBody = this.getObjectsFromResponseBody(parseDataMap);
                    if (objectsFromResponseBody == null) break;
                    ret.putAll(objectsFromResponseBody);
                    break;
                }
            }
            Map<String, String> headersMap = this.extractHeader(response.getResponseHeaders());
            ret.put(this.getResponseHeaderFieldName(), headersMap);
            return ret;
        }
        catch (Exception t) {
            throw new SystemException("", "", t);
        }
    }

    private HTTPWSResponse invokeHTTP(String serviceURL, String requestBody, Map<String, List<String>> requestHeaders) {
        HTTPWSResponse response = null;
        response = this.getServiceMethod().equalsIgnoreCase("POST") ? this.getHttpWSClient().post(serviceURL, requestBody, requestHeaders) : (this.getServiceMethod().equalsIgnoreCase("GET") ? this.getHttpWSClient().get(serviceURL, requestHeaders) : (this.getServiceMethod().equalsIgnoreCase("DELETE") ? this.getHttpWSClient().delete(serviceURL, requestHeaders) : this.getHttpWSClient().put(serviceURL, requestBody, requestHeaders)));
        return response;
    }

    private Map<String, Object> getObjectsFromResponseBody(Map responseBodyObj) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.getResponseBodyToCustomFieldMapping() == null || this.getResponseBodyToCustomFieldMapping().size() == 0) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : this.getResponseBodyToCustomFieldMapping().entrySet()) {
            logger.debug("fetching response object:" + responseBodyObj + ", propertyPath:" + entry.getValue());
            List nestedProperty = this.getCollectionsPathRetreiver().getNestedProperty(responseBodyObj, entry.getValue());
            ret.put(entry.getKey(), nestedProperty);
        }
        return ret;
    }

    private List<Object> getMultiObjectsFromBean(Object bean, String propertyPathPattern) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (propertyPathPattern == null || propertyPathPattern.trim().length() <= 0) {
            ret.add(bean);
            return ret;
        }
        int arrayWildcardIndex = propertyPathPattern.indexOf("[*]");
        int mapWildcardIndex = propertyPathPattern.indexOf("(*)");
        if (arrayWildcardIndex > -1 && mapWildcardIndex > -1 && arrayWildcardIndex < mapWildcardIndex) {
            ret.addAll(this.handleIndexedProperty(bean, propertyPathPattern, arrayWildcardIndex));
        } else if (arrayWildcardIndex > -1 && mapWildcardIndex > -1 && arrayWildcardIndex > mapWildcardIndex) {
            ret.addAll(this.handleMapProperty(bean, propertyPathPattern, mapWildcardIndex));
        } else if (arrayWildcardIndex > -1) {
            ret.addAll(this.handleIndexedProperty(bean, propertyPathPattern, arrayWildcardIndex));
        } else {
            ret.addAll(this.handleMapProperty(bean, propertyPathPattern, mapWildcardIndex));
        }
        return ret;
    }

    private List<Object> handleIndexedProperty(Object bean, String propertyPathPattern, int arrayWildcardIndex) {
        ArrayList<Object> ret = new ArrayList<Object>();
        int propertyPathPatternLength = propertyPathPattern.length();
        String propertyPath = propertyPathPattern.substring(0, arrayWildcardIndex);
        String remainingPropertyPath = null;
        boolean moreWildcard = false;
        if (propertyPathPatternLength > arrayWildcardIndex + 4) {
            remainingPropertyPath = propertyPathPattern.substring(arrayWildcardIndex + 4);
            moreWildcard = remainingPropertyPath.contains("[*]") || remainingPropertyPath.contains("(*)");
        }
        try {
            Object propertyValue = PropertyUtils.getNestedProperty((Object)bean, (String)propertyPath);
            if (propertyValue == null) {
                return ret;
            }
            int length = 0;
            length = propertyValue.getClass().isArray() ? Array.getLength(propertyValue) : ((Collection)propertyValue).size();
            for (int i = 0; i < length; ++i) {
                Object propertyValueElement;
                if (moreWildcard) {
                    propertyValueElement = PropertyUtils.getNestedProperty((Object)bean, (String)(propertyPath + "[" + i + "]"));
                    if (propertyValueElement == null) continue;
                    ret.addAll(this.getMultiObjectsFromBean(propertyValueElement, remainingPropertyPath));
                    continue;
                }
                propertyValueElement = null;
                propertyValueElement = remainingPropertyPath == null ? PropertyUtils.getNestedProperty((Object)bean, (String)(propertyPath + "[" + i + "]")) : PropertyUtils.getNestedProperty((Object)bean, (String)(propertyPath + "[" + i + "]." + remainingPropertyPath));
                if (propertyValueElement == null) continue;
                ret.addAll(this.getMultiObjectsFromBean(propertyValueElement, remainingPropertyPath));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn("Error while getting wildcard property path segment:" + propertyPath, (Throwable)e);
        }
        return ret;
    }

    private List<Object> handleMapProperty(Object bean, String propertyPathPattern, int mapWildcardIndex) {
        ArrayList<Object> ret = new ArrayList<Object>();
        int propertyPathPatternLength = propertyPathPattern.length();
        String propertyPath = propertyPathPattern.substring(0, mapWildcardIndex);
        String remainingPropertyPath = null;
        boolean moreWildcard = false;
        if (propertyPathPatternLength > mapWildcardIndex + 4) {
            remainingPropertyPath = propertyPathPattern.substring(mapWildcardIndex + 4);
            moreWildcard = remainingPropertyPath.contains("[*]") || remainingPropertyPath.contains("(*)");
        }
        try {
            Map propertyValue = (Map)PropertyUtils.getNestedProperty((Object)bean, (String)propertyPath);
            if (propertyValue == null) {
                return ret;
            }
            for (Map.Entry entry : propertyValue.entrySet()) {
                Object propertyValueElement;
                if (moreWildcard) {
                    propertyValueElement = PropertyUtils.getNestedProperty((Object)bean, (String)(propertyPath + "(" + (String)entry.getKey() + ")"));
                    if (propertyValueElement == null) continue;
                    ret.addAll(this.getMultiObjectsFromBean(propertyValueElement, remainingPropertyPath));
                    continue;
                }
                propertyValueElement = null;
                propertyValueElement = remainingPropertyPath == null ? PropertyUtils.getNestedProperty((Object)bean, (String)(propertyPath + "(" + (String)entry.getKey() + ")")) : PropertyUtils.getNestedProperty((Object)bean, (String)(propertyPath + "(" + (String)entry.getKey() + ")." + remainingPropertyPath));
                if (propertyValueElement == null) continue;
                ret.addAll(this.getMultiObjectsFromBean(propertyValueElement, remainingPropertyPath));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn("Error while getting wildcard property path segment:" + propertyPath, (Throwable)e);
        }
        return ret;
    }

    private void addRequestIdHeader(Map<String, List<String>> requestHeaders) {
        if (this.getRequestIdHeaderName() != null && this.getRequestIdHeaderName().trim().length() > 0) {
            ArrayList<String> headerValues = new ArrayList<String>();
            headerValues.add(UUID.randomUUID().toString());
            requestHeaders.put(this.getRequestIdHeaderName(), headerValues);
        }
    }

    private void addClientHostnameHeader(Map<String, List<String>> requestHeaders) {
        if (this.getClientHostHeaderName() != null && this.getClientHostHeaderName().trim().length() > 0) {
            if (localHost == null) {
                try {
                    localHost = Inet4Address.getLocalHost();
                }
                catch (UnknownHostException e) {
                    logger.warn("Error while getting local host name and IP", (Throwable)e);
                }
            }
            ArrayList<String> headerValues = new ArrayList<String>();
            headerValues.add("" + localHost);
            requestHeaders.put(this.getClientHostHeaderName(), headerValues);
        }
    }

    private Map<String, String> extractHeader(Map<String, List<String>> responseHeaders) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (responseHeaders != null && responseHeaders.size() > 0) {
            for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
                if (entry.getValue().size() > 1) {
                    for (int i = 0; i < entry.getValue().size(); ++i) {
                        ret.put(entry.getKey() + "[" + i + "]", entry.getValue().get(i));
                    }
                    continue;
                }
                if (entry.getValue().size() != 1) continue;
                ret.put(entry.getKey(), entry.getValue().get(0));
            }
        }
        return ret;
    }
}

