/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.robot.desktop;

import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

class Clipboard {
    public static final TextType HTML = new TextType("text/html");
    public static final TextType PLAIN = new TextType("text/plain");
    public static final Charset UTF8 = new Charset("UTF-8");
    public static final Charset UTF16 = new Charset("UTF-16");
    public static final Charset UNICODE = new Charset("unicode");
    public static final Charset US_ASCII = new Charset("US-ASCII");
    public static final TransferType READER = new TransferType(Reader.class);
    public static final TransferType INPUT_STREAM = new TransferType(InputStream.class);
    public static final TransferType CHAR_BUFFER = new TransferType(CharBuffer.class);
    public static final TransferType BYTE_BUFFER = new TransferType(ByteBuffer.class);

    private Clipboard() {
    }

    public static void clear() {
        Clipboard.getSystemClipboard().setContents(new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[0];
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return false;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                throw new UnsupportedFlavorException(flavor);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText() {
        Transferable clipboardContents = Clipboard.getSystemClipboard().getContents(Clipboard.class);
        DataFlavor[] flavors = clipboardContents.getTransferDataFlavors();
        if (flavors.length == 0) {
            return null;
        }
        DataFlavor textFlavor = DataFlavor.selectBestTextFlavor(flavors);
        if (textFlavor == null) {
            return null;
        }
        Reader clipboardReader = null;
        try {
            clipboardReader = textFlavor.getReaderForText(clipboardContents);
            StringBuffer sb = new StringBuffer();
            char[] cbuf = new char[4096];
            int rcount = clipboardReader.read(cbuf);
            while (rcount != -1) {
                sb.append(cbuf, 0, rcount);
                rcount = clipboardReader.read(cbuf);
            }
            String string = sb.toString();
            return string;
        }
        catch (UnsupportedFlavorException e) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (clipboardReader != null) {
                try {
                    clipboardReader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void putText(CharSequence data) {
        StringSelection copy = new StringSelection(((Object)data).toString());
        Clipboard.getSystemClipboard().setContents(copy, copy);
    }

    public static void putText(TextType type, Charset charset, TransferType transferType, CharSequence data) {
        String mimeType = type + "; charset=" + charset + "; class=" + transferType;
        TextTransferable transferable = new TextTransferable(mimeType, ((Object)data).toString());
        Clipboard.getSystemClipboard().setContents(transferable, transferable);
    }

    public static java.awt.datatransfer.Clipboard getSystemClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static class TransferType {
        private Class dataClass;

        private TransferType(Class streamClass) {
            this.dataClass = streamClass;
        }

        public Class getDataClass() {
            return this.dataClass;
        }

        public String toString() {
            return this.dataClass.getName();
        }
    }

    public static class Charset {
        private String name;

        private Charset(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class TextType {
        private String type;

        private TextType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    private static class TextTransferable
    implements Transferable,
    ClipboardOwner {
        private String data;
        private DataFlavor flavor;

        public TextTransferable(String mimeType, String data) {
            this.flavor = new DataFlavor(mimeType, "Text");
            this.data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            boolean b = this.flavor.getPrimaryType().equals(flavor.getPrimaryType());
            return b || flavor.equals(DataFlavor.stringFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.isRepresentationClassInputStream()) {
                return new StringBufferInputStream(this.data);
            }
            if (flavor.isRepresentationClassReader()) {
                return new StringReader(this.data);
            }
            if (flavor.isRepresentationClassCharBuffer()) {
                return CharBuffer.wrap(this.data);
            }
            if (flavor.isRepresentationClassByteBuffer()) {
                return ByteBuffer.wrap(this.data.getBytes());
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public void lostOwnership(java.awt.datatransfer.Clipboard clipboard, Transferable contents) {
        }
    }
}

