/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.robot.desktop;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import org.sikuli.api.robot.Env;
import org.sikuli.api.robot.Key;
import org.sikuli.api.robot.OS;

class AWTRobot
extends Robot {
    static final int MAX_DELAY = 60000;
    public static double DelayBeforeDrop = 0.3;
    public static double DelayAfterDrag = 0.3;
    GraphicsDevice gdev;

    public AWTRobot(GraphicsDevice gdev) throws AWTException {
        super(gdev);
        this.gdev = gdev;
    }

    public AWTRobot() throws AWTException {
    }

    public Point getOrigin() {
        return this.gdev.getDefaultConfiguration().getBounds().getLocation();
    }

    @Override
    public void delay(int ms) {
        if (ms < 0) {
            ms = 0;
        }
        while (ms > 60000) {
            super.delay(60000);
            ms -= 60000;
        }
        super.delay(ms);
    }

    public BufferedImage captureScreen(Rectangle rect) {
        return this.createScreenCapture(rect);
    }

    public void pressModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.keyPress(16);
        }
        if ((modifiers & 2) != 0) {
            this.keyPress(17);
        }
        if ((modifiers & 8) != 0) {
            this.keyPress(18);
        }
        if ((modifiers & 4) != 0) {
            if (Env.getOS() == OS.WINDOWS) {
                this.keyPress(524);
            } else {
                this.keyPress(157);
            }
        }
    }

    public void releaseModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.keyRelease(16);
        }
        if ((modifiers & 2) != 0) {
            this.keyRelease(17);
        }
        if ((modifiers & 8) != 0) {
            this.keyRelease(18);
        }
        if ((modifiers & 4) != 0) {
            if (Env.getOS() == OS.WINDOWS) {
                this.keyRelease(524);
            } else {
                this.keyRelease(157);
            }
        }
    }

    protected void doType(KeyMode mode, int ... keyCodes) {
        if (mode == KeyMode.PRESS_ONLY) {
            for (int i = 0; i < keyCodes.length; ++i) {
                this.keyPress(keyCodes[i]);
            }
        } else if (mode == KeyMode.RELEASE_ONLY) {
            for (int i = 0; i < keyCodes.length; ++i) {
                this.keyRelease(keyCodes[i]);
            }
        } else {
            int i;
            for (i = 0; i < keyCodes.length; ++i) {
                this.keyPress(keyCodes[i]);
            }
            for (i = 0; i < keyCodes.length; ++i) {
                this.keyRelease(keyCodes[i]);
            }
        }
    }

    public void typeChar(char character, KeyMode mode) {
        this.doType(mode, Key.toJavaKeyCode(character));
    }

    public Object getDevice() {
        return null;
    }

    public static enum KeyMode {
        PRESS_ONLY,
        RELEASE_ONLY,
        PRESS_RELEASE;

    }
}

