/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.primitives.Doubles;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_core;
import org.sikuli.core.cv.ImagePreprocessor;
import org.sikuli.core.cv.VisionUtils;
import org.sikuli.core.search.TemplateMatcher;
import org.sikuli.core.search.internal.TemplateMatchingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchByTextureAndColorAtOriginalResolution {
    private static Logger logger = LoggerFactory.getLogger(SearchByTextureAndColorAtOriginalResolution.class);
    private opencv_core.IplImage query;
    private opencv_core.IplImage input;
    private opencv_core.CvScalar avergerColorOfTheQueryImage;
    private opencv_core.IplImage resultMatrix = null;
    private ColorRegionMatch fetchedMatch = null;
    private LinkedList<ColorRegionMatch> prefetchedCandidates = new LinkedList();
    private int MAX_NUMBER_TO_PREFETCH = 10;

    public SearchByTextureAndColorAtOriginalResolution(opencv_core.IplImage input, opencv_core.IplImage query) {
        this.input = input;
        this.query = query;
    }

    public void execute() {
        opencv_core.CvScalar avg;
        this.resultMatrix = TemplateMatchingUtilities.computeTemplateMatchResultMatrix((opencv_core.IplImage)ImagePreprocessor.createGrayscale((opencv_core.IplImage)this.input), (opencv_core.IplImage)ImagePreprocessor.createGrayscale((opencv_core.IplImage)this.query));
        logger.trace("channels:" + this.query.nChannels());
        logger.trace("alpha channel:" + this.query.alphaChannel());
        logger.trace("bt:" + this.query.getBufferedImageType());
        if (this.query.nChannels() == 4) {
            this.query = VisionUtils.cloneWithoutAlphaChannel((opencv_core.IplImage)this.query);
        }
        if (this.input.nChannels() == 4) {
            this.input = VisionUtils.cloneWithoutAlphaChannel((opencv_core.IplImage)this.input);
        }
        this.avergerColorOfTheQueryImage = avg = opencv_core.cvAvg((opencv_core.CvArr)this.query, null);
    }

    private static double calculateL1Distance(opencv_core.CvScalar a, opencv_core.CvScalar b) {
        logger.trace(SearchByTextureAndColorAtOriginalResolution.toString(a) + "<->" + SearchByTextureAndColorAtOriginalResolution.toString(b));
        double d = 0.0;
        for (int i = 0; i < 3; ++i) {
            d += Math.abs(a.getVal(i) - b.getVal(i));
        }
        return d;
    }

    private static String toString(opencv_core.CvScalar a) {
        String s = "[";
        for (int i = 0; i < 4; ++i) {
            s = s + String.format("%3.0f ", a.getVal(i));
        }
        s = s + "]";
        return s;
    }

    private double calculateColorDifferenceBetweenMatchedRegionAndTarget(Rectangle m) {
        opencv_core.cvSetImageROI((opencv_core.IplImage)this.input, (opencv_core.CvRect)opencv_core.cvRect((int)m.x, (int)m.y, (int)m.width, (int)m.height));
        opencv_core.CvScalar averageColorOfTheMatchedRegion = opencv_core.cvAvg((opencv_core.CvArr)this.input, null);
        double diff = SearchByTextureAndColorAtOriginalResolution.calculateL1Distance(this.avergerColorOfTheQueryImage, averageColorOfTheMatchedRegion);
        opencv_core.cvResetImageROI((opencv_core.IplImage)this.input);
        return diff;
    }

    private double calculateColorMatchScore(Rectangle r) {
        double rawScore = this.calculateColorDifferenceBetweenMatchedRegionAndTarget(r);
        return (255.0 - Math.min(rawScore, 255.0)) / 255.0;
    }

    private ColorRegionMatch fetchNextColorRegionMath() {
        TemplateMatchingUtilities.TemplateMatchResult result = TemplateMatchingUtilities.fetchNextBestMatch((opencv_core.IplImage)this.resultMatrix, (opencv_core.IplImage)this.query);
        ColorRegionMatch newMatch = new ColorRegionMatch(result.getBounds());
        newMatch.colorScore = this.calculateColorMatchScore(result.getBounds());
        newMatch.textureScore = result.score;
        return newMatch;
    }

    private void prefetch() {
        boolean hasPrefetchedEnough;
        if (this.fetchedMatch != null) {
            this.prefetchedCandidates.add(this.fetchedMatch);
            this.fetchedMatch = null;
        }
        do {
            boolean isDropInTextureSimilaritySingificant;
            ColorRegionMatch previousMatch = this.prefetchedCandidates.isEmpty() ? null : this.prefetchedCandidates.getLast();
            ColorRegionMatch newMatch = this.fetchNextColorRegionMath();
            logger.trace("prefecth (" + this.prefetchedCandidates.size() + ")" + (Object)((Object)newMatch));
            double dropInTextureSimilarity = previousMatch == null ? 0.0 : 1.0 - newMatch.textureScore / previousMatch.textureScore;
            boolean bl = isDropInTextureSimilaritySingificant = dropInTextureSimilarity > 0.15;
            if (isDropInTextureSimilaritySingificant) {
                previousMatch = newMatch;
                break;
            }
            this.prefetchedCandidates.add(newMatch);
        } while (!(hasPrefetchedEnough = this.prefetchedCandidates.size() >= this.MAX_NUMBER_TO_PREFETCH));
        Collections.sort(this.prefetchedCandidates, new Comparator<ColorRegionMatch>(){

            @Override
            public int compare(ColorRegionMatch a, ColorRegionMatch b) {
                return Doubles.compare((double)b.getScore(), (double)a.getScore());
            }
        });
    }

    public ColorRegionMatch fetchNext() {
        if (this.prefetchedCandidates.isEmpty()) {
            this.prefetch();
        }
        ColorRegionMatch colorRegionMatch = this.prefetchedCandidates.poll();
        return colorRegionMatch;
    }

    static class ColorRegionMatch
    extends TemplateMatcher.Result {
        double colorScore;
        double textureScore;

        public ColorRegionMatch(Rectangle r) {
            super(r.getBounds());
        }

        public double getScore() {
            double s1 = this.textureScore;
            double s2 = this.colorScore;
            double s = s2 > 0.85 ? s1 : 0.0;
            return s;
        }

        public String toString() {
            return " x = " + this.x + ", y = " + this.y + ", textureScore = " + String.format("%1.3f", this.textureScore) + ", colorScore = " + String.format("%1.3f", this.colorScore);
        }
    }
}

