/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

import java.util.Arrays;
import java.util.HashSet;
import org.osjava.jardiff.ClassInfo;
import org.osjava.jardiff.DiffCriteria;
import org.osjava.jardiff.FieldInfo;
import org.osjava.jardiff.MethodInfo;
import org.osjava.jardiff.Tools;

public class PublicDiffCriteria
implements DiffCriteria {
    @Override
    public boolean validClass(ClassInfo info) {
        return !info.isSynthetic() && info.isPublic();
    }

    @Override
    public boolean validMethod(MethodInfo info) {
        return !info.isSynthetic() && info.isPublic();
    }

    @Override
    public boolean validField(FieldInfo info) {
        return !info.isSynthetic() && info.isPublic();
    }

    @Override
    public boolean differs(ClassInfo oldInfo, ClassInfo newInfo) {
        HashSet<String> newInterfaces;
        if (Tools.isClassAccessChange(oldInfo.getAccess(), newInfo.getAccess())) {
            return true;
        }
        if (oldInfo.getSupername() == null ? newInfo.getSupername() != null : !oldInfo.getSupername().equals(newInfo.getSupername())) {
            return true;
        }
        HashSet<String> oldInterfaces = new HashSet<String>(Arrays.asList(oldInfo.getInterfaces()));
        return !oldInterfaces.equals(newInterfaces = new HashSet<String>(Arrays.asList(newInfo.getInterfaces())));
    }

    @Override
    public boolean differs(MethodInfo oldInfo, MethodInfo newInfo) {
        HashSet<String> newExceptions;
        HashSet<String> oldExceptions;
        if (Tools.isMethodAccessChange(oldInfo.getAccess(), newInfo.getAccess())) {
            return true;
        }
        return oldInfo.getExceptions() == null || newInfo.getExceptions() == null ? oldInfo.getExceptions() != newInfo.getExceptions() : !(oldExceptions = new HashSet<String>(Arrays.asList(oldInfo.getExceptions()))).equals(newExceptions = new HashSet<String>(Arrays.asList(newInfo.getExceptions())));
    }

    @Override
    public boolean differs(FieldInfo oldInfo, FieldInfo newInfo) {
        if (Tools.isFieldAccessChange(oldInfo.getAccess(), newInfo.getAccess())) {
            return true;
        }
        return oldInfo.getValue() == null || newInfo.getValue() == null ? oldInfo.getValue() != newInfo.getValue() : !oldInfo.getValue().equals(newInfo.getValue());
    }
}

