'use strict';

import './visualization-information.scss';

export default angular.module('app.visualization-information.directive', [])
    .directive('visualizationInformation', visualizationInformation);

visualizationInformation.$inject = [];

function visualizationInformation() {
    vizInfoLink.$inject = ['scope', 'ele', 'attrs', 'ctrl'];

    return {
        scope: {},
        restrict: 'E',
        require: ['^widget'],
        template: require('./visualization-information.directive.html'),
        link: vizInfoLink
    };

    function vizInfoLink(scope, ele, attrs, ctrl) {
        scope.widgetCtrl = ctrl[0];

        var barSvg = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="30.98px" height="30.361px" viewBox="0 0 30.98 30.361" enable-background="new 0 0 30.98 30.361" xml:space="preserve" class="svg replaced-svg"><g><rect x="6.253" y="15.471" width="5.076" height="9.22"></rect><rect x="12.952" y="8.433" width="5.075" height="16.258"></rect><rect x="19.652" y="11.479" width="5.075" height="13.212"></rect></g></svg>',
            circleSvg = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="29.132px" height="30.362px" viewBox="0 0 29.132 30.362" enable-background="new 0 0 29.132 30.362" xml:space="preserve" class="svg replaced-svg"><circle cx="15.143" cy="15.463" r="12.562"></circle></svg>',
            scatterSvg = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="30.98px" height="30.361px" viewBox="0 0 30.98 30.361" enable-background="new 0 0 30.98 30.361" xml:space="preserve" class="svg replaced-svg"><g><circle cx="5.726" cy="5.853" r="2.69"></circle><circle cx="15.473" cy="5.853" r="2.69"></circle><circle cx="25.221" cy="5.853" r="2.69"></circle></g><g><circle cx="5.726" cy="15.321" r="2.69"></circle><circle cx="15.473" cy="15.321" r="2.69"></circle><circle cx="25.221" cy="15.321" r="2.69"></circle></g><g><circle cx="5.726" cy="24.789" r="2.69"></circle><circle cx="15.473" cy="24.789" r="2.69"></circle><circle cx="25.221" cy="24.789" r="2.69"></circle></g></svg>',
            hamburgerSvg = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="30.981px" height="30.362px" viewBox="0 0 30.981 30.362" enable-background="new 0 0 30.981 30.362" xml:space="preserve" class="svg replaced-svg"><rect x="3.307" y="2.85" width="25" height="3.888"></rect><rect x="3.307" y="13.318" width="25" height="3.888"></rect><rect x="3.307" y="24.086" width="25" height="3.888"></rect></svg>',
            areaSvg = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="30.98px" height="30.361px" viewBox="0 0 30.98 30.361" enable-background="new 0 0 30.98 30.361" xml:space="preserve" class="svg replaced-svg"><g><path d="M-0.309,22.551v-3.64c0-0.66,0.323-1.277,0.864-1.655c0,0,0.811-0.721,1.326-1.052c0.515-0.334,1.564-0.373,2.012-0.35   l0.031,0.001c1.582,0.082,2.779-0.384,4.198-1.084l0.294-0.146c0.434-0.214,0.931-0.265,1.399-0.144l0.607,0.158   c1.162,0.302,2.396,0.386,3.474-0.338c1.079-0.723,4.862-5.11,5.847-5.978c0.983-0.865,2.476-0.605,3.104,0.523l1.069,1.912   c0.482,0.865,1.521,1.252,2.45,0.914l0.031-0.012c0.875-0.318,1.852,0.004,2.367,0.776l1.875,2.81   c0.223,0.333,0.34,0.722,0.34,1.121v6.181"></path></g></svg>',
            octogonSvg = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="30.98px" height="30.361px" viewBox="0 0 30.98 30.361" enable-background="new 0 0 30.98 30.361" xml:space="preserve" class="svg replaced-svg"><polygon points="2.99,7.964 15.491,0.746 27.99,7.964 27.99,22.396 15.491,29.615 2.99,22.396 "></polygon></svg>',
            squareSvg = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="30.981px" height="30.362px" viewBox="0 0 30.981 30.362" enable-background="new 0 0 30.981 30.362" xml:space="preserve" class="svg replaced-svg"><rect x="2.941" y="2.995" width="25" height="25"></rect></svg>',
            texasSvg = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="30.981px" height="30.362px" viewBox="0 0 30.981 30.362" enable-background="new 0 0 30.981 30.362" xml:space="preserve" class="svg replaced-svg"><path d="M29.97,14.954l-0.91-1.454c-0.102-0.162-0.197-0.5-0.197-0.693v-2.471c0-0.445-0.318-0.896-0.738-1.046l-1.565-0.56  c-0.302-0.108-0.779-0.185-1.106-0.175l-3.94,0.108h-0.038c-0.232,0-0.592-0.051-0.795-0.114l-4.042-1.253  c-0.086-0.025-0.182-0.156-0.182-0.249V2.628c0-0.497-0.401-0.983-0.894-0.993h-5.342h-0.019c-0.483,0-0.894,0.356-0.913,0.84v10.18  c-0.003,0.051,0.051,0.099,0,0.099H2.264c-0.433,0-0.582,0.248-0.626,0.355c-0.044,0.109-0.114,0.388,0.194,0.694l2.783,2.758  c0.153,0.149,0.362,0.467,0.439,0.665l0.677,1.71c0.133,0.344,0.486,0.728,0.814,0.897l1.908,0.973  c0.127,0.067,0.271,0.102,0.417,0.102c0.334,0,0.646-0.178,0.812-0.464l0.486-0.837c0.067-0.114,0.27-0.238,0.4-0.245l0.91-0.038  H11.5c0.194,0,0.496,0.086,0.648,0.181l1.367,0.877c0.169,0.108,0.41,0.373,0.506,0.55l3.326,6.278  c0.181,0.34,0.598,0.668,0.97,0.763l3.241,0.817c0.07,0.019,0.143,0.028,0.213,0.028c0.213,0,0.407-0.092,0.531-0.248  c0.133-0.168,0.175-0.395,0.118-0.633l-0.455-1.873c-0.041-0.168-0.006-0.486,0.07-0.643l1.087-2.207  c0.083-0.168,0.318-0.423,0.48-0.518l5.463-3.199c0.337-0.198,0.643-0.633,0.712-1.019l0.42-2.333  C30.266,15.781,30.167,15.269,29.97,14.954z"></path></svg>',
            triangleSvg = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="30.981px" height="30.362px" viewBox="0 0 30.981 30.362" enable-background="new 0 0 30.981 30.362" xml:space="preserve" class="svg replaced-svg"><polyline points="0,27.358 15.468,2.294 30.936,27.358 "></polyline></svg>',
            CHART = 'Chart',
            PLOT = 'Plot',
            DIAGRAM = 'Diagram',
            CORRELATION = 'Correlation',
            DISTRIBUTION = 'Distribution',
            COMPARISON = 'Comparison',
            TREND_OVER_TIME = 'Trend over time',
            CONCEPT_VIZ = 'Concept visualization',
            GEOSPATIAL = 'Geospatial',
            GEO_DATA = 'Geographical data',
            PART_TO_WHOLE = 'Part to whole';

        scope.curViz = '';
        scope.family = '';
        scope.function = [];
        scope.shape = [];
        scope.url = 'http://datavizproject.com/data-type/';
        scope.formatTitle = formatTitle;

        /**
         * @name formatTitle
         * @desc takes visualization name and formats it to a title
         * @return {string} formatted title
         */
        function formatTitle() {
            var title = scope.curViz.split('-');

            // making the assumption here that viz separated by - is 
            // an echart so we want to get rid of the echart part
            if (title.length > 1) {
                title.pop();
                title = title.map(function (word) {
                    return capitalize(word);
                });
            }
            title = title.join('').split('');

            return title.map(function (char, idx) {
                if (char === char.toUpperCase() && idx !== 0) {
                    return ' ' + char;
                } else if (char === char.toUpperCase()) {
                    return char;
                }

                return char;
            }).join('');
        }

        /**
         * @name capitalize
         * @param {string} word the word to capitalize
         * @desc capitalizes a word
         * @return {string} the word capitalized
         */
        function capitalize(word) {
            var capitalized = '';
            capitalized += word[0].toUpperCase();
            capitalized += word.substr(1, word.length);

            return capitalized;
        }

        function initialize() {
            scope.curViz = scope.widgetCtrl.getWidget('view.visualization.layout');

            if (scope.curViz === 'bar-echarts' || scope.curViz === 'Column') {
                scope.url += 'bar-chart';
                scope.family = CHART;
                scope.function = [COMPARISON, TREND_OVER_TIME];
                scope.shape = [barSvg];
            } else if (scope.curViz === 'scatter-echarts' || scope.curViz === 'Scatter') {
                scope.url += 'scatter-plot';
                scope.family = PLOT;
                scope.function = [CORRELATION, DISTRIBUTION];
                scope.shape = [scatterSvg];
            } else if (scope.curViz === 'tree-echarts' || scope.curViz === 'Dendrogram') {
                scope.url += 'dendrogram';
                scope.family = DIAGRAM;
                scope.function = [CORRELATION];
                scope.shape = [hamburgerSvg];
            } else if (scope.curViz === 'polar-bar-echarts' || scope.curViz === 'Polar') {
                scope.url += 'circular-bar-chart';
                scope.family = CHART;
                scope.function = [COMPARISON];
                scope.shape = [barSvg, circleSvg];
            } else if (scope.curViz === 'pie-echarts' || scope.curViz === 'Pie') {
                scope.url += 'pie-chart';
                scope.family = CHART;
                scope.function = [COMPARISON];
                scope.shape = [circleSvg];
            } else if (scope.curViz === 'line-echarts' || scope.curViz === 'Line') {
                scope.url += 'line-chart';
                scope.family = CHART;
                scope.function = [DISTRIBUTION, TREND_OVER_TIME];
                scope.shape = [hamburgerSvg];
            } else if (scope.curViz === 'area-echarts' || scope.curViz === 'Area') {
                scope.url += 'area-chart';
                scope.family = CHART;
                scope.function = [DISTRIBUTION, TREND_OVER_TIME];
                scope.shape = [areaSvg];
            } else if (scope.curViz === 'sankey-echarts' || scope.curViz === 'Sankey') {
                scope.url += 'sankey-diagram';
                scope.family = DIAGRAM;
                scope.function = [COMPARISON, CORRELATION];
                scope.shape = [areaSvg, hamburgerSvg];
            } else if (scope.curViz === 'radar-echarts' || scope.curViz === 'Radar') {
                scope.url += 'radar-diagram';
                scope.family = CHART;
                scope.function = [COMPARISON, DISTRIBUTION];
                scope.shape = [hamburgerSvg, octogonSvg];
            } else if (scope.curViz === 'graph-echarts' || scope.curViz === 'Graph' || scope.curViz === 'VivaGraph') {
                scope.url += 'network-visualisation';
                scope.family = DIAGRAM;
                scope.function = [CONCEPT_VIZ, CORRELATION];
                scope.shape = [scatterSvg, hamburgerSvg];
            } else if (scope.curViz === 'Grid') {
                scope.url += 'table-chart';
                scope.family = CHART;
                scope.function = [COMPARISON];
                scope.shape = [squareSvg];
            } else if (scope.curViz === 'Radial') {
                scope.url += 'radical-histogram';
                scope.family = CHART;
                scope.function = [COMPARISON];
                scope.shape = [barSvg, circleSvg];
            } else if (scope.curViz === 'ScatterplotMatrix') {
                scope.url += '';
                scope.family = PLOT;
                scope.function = [CORRELATION, DISTRIBUTION];
                scope.shape = [scatterSvg];
            } else if (scope.curViz === 'parallel-coordinates-echarts' || scope.curViz === 'ParallelCoordinates') {
                scope.url += 'parallel-coordinates';
                scope.family = CHART;
                scope.function = [COMPARISON];
                scope.shape = [hamburgerSvg];
            } else if (scope.curViz === 'SingleAxisCluster' || scope.curViz === 'Cluster') {
                scope.url += 'cluster-analysis';
                scope.family = PLOT;
                scope.function = [DISTRIBUTION];
                scope.shape = [circleSvg, scatterSvg];
            } else if (scope.curViz === 'heatmap-echarts' || scope.curViz === 'HeatMap') {
                scope.url += 'heat-map';
                scope.family = [CHART];
                scope.function = [COMPARISON, CORRELATION, DISTRIBUTION, TREND_OVER_TIME];
                scope.shape = [squareSvg];
            } else if (scope.curViz === 'treemap-echarts' || scope.curViz === 'TreeMap') {
                scope.url += 'treemap';
                scope.family = CHART;
                scope.function = [COMPARISON, DISTRIBUTION];
                scope.shape = [squareSvg];
            } else if (scope.curViz === 'map-echarts' || scope.curViz === 'Map') {
                scope.url += 'bubble-map-chart';
                scope.family = GEOSPATIAL;
                scope.function = [COMPARISON, DISTRIBUTION];
                scope.shape = [circleSvg, texasSvg];
            } else if (scope.curViz === 'choropleth-echarts' || scope.curViz === 'Choropleth') {
                scope.url += 'choropleth-map-2';
                scope.family = GEOSPATIAL;
                scope.function = [COMPARISON, DISTRIBUTION, GEO_DATA];
                scope.shape = [texasSvg];
            } else if (scope.curViz === 'Pack') {
                scope.url += 'packed-circle-chart';
                scope.family = CHART;
                scope.function = [COMPARISON, DISTRIBUTION];
                scope.shape = [circleSvg];
            } else if (scope.curViz === 'Sunburst') {
                scope.url += 'donut-chart';
                scope.family = CHART;
                scope.function = [COMPARISON];
                scope.shape = [circleSvg];
            } else if (scope.curViz === 'Gantt') {
                scope.url += 'gannt-chart';
                scope.family = CHART;
                scope.function = [DISTRIBUTION];
                scope.shape = [barSvg];
            } else if (scope.curViz === 'Cloud') {
                scope.url += 'tag-cloud';
                scope.family = CHART;
                scope.function = [COMPARISON, DISTRIBUTION];
                scope.shape = [circleSvg];
            } else if (scope.curViz === 'boxwhisker-echarts' || scope.curViz === 'BoxWhisker') {
                scope.url += 'box-plot';
                scope.family = PLOT;
                scope.function = [COMPARISON, DISTRIBUTION];
                scope.shape = [hamburgerSvg, squareSvg];
            } else if (scope.curViz === 'Bubble') {
                scope.url += 'proportional-area-chart-circle';
                scope.family = CHART;
                scope.function = [COMPARISON];
                scope.shape = [circleSvg];
            } else if (scope.curViz === 'Funnel') {
                scope.url += 'funnel-chart';
                scope.family = CHART;
                scope.function = [PART_TO_WHOLE, TREND_OVER_TIME];
                scope.shape = [triangleSvg];
            } else if (scope.curViz === 'Gauge') {
                scope.url += 'angular-gauge-chart';
                scope.family = CHART;
                scope.function = [''];
                scope.shape = [circleSvg];
            } else if (scope.curViz === 'Bullet') {
                scope.url += 'bullet-graph';
                scope.family = CHART;
                scope.function = [PART_TO_WHOLE];
                scope.shape = [barSvg, hamburgerSvg];
            } else if (scope.curViz === 'Scatter3d') {
                scope.url += '3d-scatterplot';
                scope.family = CHART;
                scope.function = [CORRELATION, DISTRIBUTION, TREND_OVER_TIME];
                scope.shape = [scatterSvg];
            }
        }

        initialize();

        scope.$on('$destroy', function () {
            console.log('destroying visualization information');
        });
    }
}