module.exports = {
    'name': 'TreeMap',
    'icon': require('images/treemap.svg'),
    'widgetList': {
        'tags': [
            'Visualization',
            'JVChart'
        ],
        'showOn': 'none',
        'hideHandles': [],
        'quickMenu': [
            'events',
            'color-by-value',
            'color-panel-mode',
            'infinite-viz'
        ]
    },
    'content': {
        'template': {
            'name': 'treemap-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'TreeMap',
        'visibleModes': [
            'default-mode',
            'edit-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-panel',
            'color-by-value',
            'sort-values',
            'format-data-values',
            'toggle-canvas',
            'toggle-legend',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [
            {
                'model': 'series',
                'name': 'Series',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'validate',
                'optional': false,
                'multiField': false,
                'description': 'Try adding one dimension (i.e. Movie Genre). Each instnace of this dimension will represent a different colored group within the treemap.'
            },
            {
                'model': 'label',
                'name': 'Label',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'validate',
                'optional': false,
                'multiField': false,
                'description': 'Try adding one dimension (i.e. Movie Title). Each instnace of this dimension will represent a box within its respective group.'
            },
            {
                'model': 'size',
                'name': 'Size',
                'acceptableTypes': [
                    'NUMBER'
                ],
                'group': 'math',
                'optional': false,
                'multiField': false,
                'description': 'Try adding one numerical dimension (i.e. Movie Budget). The numerical value of this dimension represents the size of each box.'
            },
            {
                'model': 'tooltip',
                'name': 'Tooltip',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'validate',
                'optional': true,
                'multiField': true,
                'description': 'Try adding one or several dimensions (i.e. Producer). Each instance of this dimension will appear in the tooltip when hovering.'
            }
        ],
        'color': {
            'series': {
                'multiField': false,
                'instances': true
            }
        }
    },
    'lazy': true
};
