module.exports = {
    'name': 'SingleAxisCluster',
    'icon': require('images/single-axis-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization',
            'JVChart'
        ],
        'showOn': 'none'
    },
    'content': {
        'template': {
            'name': 'single-axis-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'SingleAxisCluster',
        'visibleModes': [
            'default-mode',
            'edit-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-by-value',
            'format-data-values',
            'sort-values',
            'toggle-canvas',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [
            {
                'model': 'label',
                'name': 'Label',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'validate',
                'optional': false,
                'multiField': false,
                'description': 'Try adding one dimension (i.e. Movie Genre). Each instance within this dimension will represent a point on the plot.'
            },
            {
                'model': 'x',
                'name': 'X-Axis',
                'acceptableTypes': [
                    'NUMBER'
                ],
                'group': 'math',
                'optional': false,
                'multiField': false,
                'description': 'Try adding one numerical dimension (i.e. Movie Budget). The values of this dimension will represent the x-axis.'
            },
            {
                'model': 'size',
                'name': 'Size',
                'acceptableTypes': [
                    'NUMBER'
                ],
                'group': 'math',
                'optional': true,
                'multiField': false,
                'description': 'Try adding one numerical dimension (i.e. Movie Revenue). The values of this dimension will represent the size of their respective point on the plot.'
            },
            {
                'model': 'facet',
                'name': 'Facet',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'math',
                'optional': true,
                'multiField': false,
                'description': 'Try adding one dimension (i.e. Movie Rating). Each instance of this dimension will represent a new x-axis line.'
            },
            {
                'model': 'tooltip',
                'name': 'Tooltip',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'concat',
                'optional': true,
                'multiField': true,
                'description': 'Try adding one or several dimensions (i.e. Producer). Each instance of this dimension will appear in the tooltip when hovering'
            }
        ],
        'color': {}
    },
    'lazy': true
};
