module.exports = {
    'name': 'Scatter',
    'icon': require('images/scatter-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization',
            'JVChart'
        ],
        'showOn': 'none',
        'hideHandles': [],
        'quickMenu': [
            'events',
            'unfilter',
            'color-panel-mode',
            'color-by-value',
            'infinite-viz'
        ]
    },
    'content': {
        'template': {
            'name': 'scatter-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Scatter',
        'visibleModes': [
            'default-mode',
            'edit-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-panel',
            'color-by-value',
            'sort-values',
            'format-data-values',
            'reverse-x',
            'reverse-y',
            'toggle-legend',
            'line-guide',
            'toggle-z',
            'toggle-canvas',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [
            {
                'model': 'label',
                'name': 'Label',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'validate',
                'optional': false,
                'multiField': false,
                'description': 'Try adding one dimension (i.e. Movie Title). Each instance within this dimension will represent a point on the plot.'
            },
            {
                'model': 'x',
                'name': 'X-Axis',
                'acceptableTypes': [
                    'NUMBER'
                ],
                'group': 'math',
                'optional': false,
                'multiField': false,
                'description': 'Try adding one numerical dimension (i.e. Movie Budget). The values of this dimension will represent the x-axis.'
            },
            {
                'model': 'y',
                'name': 'Y-Axis',
                'acceptableTypes': [
                    'NUMBER'
                ],
                'group': 'math',
                'optional': false,
                'multiField': false,
                'description': 'Try adding one numerical dimension (i.e. Movie Revenue). The values of this dimension will represent the y-axis.'
            },
            {
                'model': 'z',
                'name': 'Size',
                'acceptableTypes': [
                    'NUMBER'
                ],
                'group': 'math',
                'optional': true,
                'multiField': false,
                'description': 'Try adding one numerical dimension (i.e. IMBD Score). The values of this dimension will represent the size of their respective point on the plot.'
            },
            {
                'model': 'series',
                'name': 'Color',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'concat',
                'optional': true,
                'multiField': false,
                'description': 'Try adding one dimension (i.e. Movie Genre). Each instance within this dimension will represent a color.'
            },
            {
                'model': 'tooltip',
                'name': 'Tooltip',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'concat',
                'optional': true,
                'multiField': true,
                'description': 'Try adding one or several dimensions (i.e. Director). Each instance of this dimension will appear in the tooltip when hovering.'
            }
        ],
        'color': {
            'series': {
                'multiField': false,
                'instances': true,
                'returnIfFound': true
            },
            'label': {
                'multiField': false,
                'instances': false
            }
        }
    },
    'tools': {
        'toggleZ': true,
        'lineGuide': true,
        'customAxisNeeded': false,
        'xReversed': false,
        'yReversed': false
    },
    'lazy': true
};
