'use strict';

export default angular.module('app.kpi-settings.directive', [])
    .directive('kpiSettings', kpiSettingsDirective);

kpiSettingsDirective.$inject = ['VIZ_COLORS', 'semossCoreService'];

function kpiSettingsDirective(VIZ_COLORS, semossCoreService) {
    kpiSettingsCtrl.$inject = [];
    kpiSettingsLink.$inject = ['scope', 'ele', 'attrs', 'ctrl'];

    return {
        scope: {},
        restrict: 'EA',
        controllerAs: 'kpiSettings',
        bindToController: {},
        template: require('./kpi-settings.directive.html'),
        controller: kpiSettingsCtrl,
        link: kpiSettingsLink,
        require: ['^widget']
    };

    function kpiSettingsCtrl() {}

    function kpiSettingsLink(scope, ele, attrs, ctrl) {
        scope.widgetCtrl = ctrl[0];


        // variables
        scope.kpiSettings.colorTheme = VIZ_COLORS.COLOR_SEMOSS;
        scope.kpiSettings.options = {};

        // functions
        scope.kpiSettings.execute = execute;
        scope.kpiSettings.reset = reset;

        /** Logic **/
        /**
         * @name resetPanel
         * @desc function that is resets the panel when the data changes
         * @returns {void}
         */
        function resetPanel() {
            var individualTools = scope.widgetCtrl.getWidget('view.visualization.tools.individual.KPI') || {},
                sharedTools = scope.widgetCtrl.getWidget('view.visualization.tools.shared') || {},
                options;

            options = angular.extend(sharedTools, individualTools) || {};


            scope.kpiSettings.colorTheme = semossCoreService.visualization.getColorPalette(options.colorName);

            scope.kpiSettings.options = {
                kpiColor: options.hasOwnProperty('kpiColor') ? options.kpiColor : '#00A8C1',
                kpiFormat: options.hasOwnProperty('kpiFormat') ? options.kpiFormat : 'None',
                kpiRound: options.hasOwnProperty('kpiRound') ? options.kpiRound : false,
                kpiRoundShift: options.hasOwnProperty('kpiRoundShift') ? options.kpiRoundShift : 2,
                kpiValueSize: options.hasOwnProperty('kpiValueSize') ? options.kpiValueSize : 28,
                kpiTitleText: options.hasOwnProperty('kpiTitleText') ? options.kpiTitleText : '',
                kpiTitleSize: options.hasOwnProperty('kpiTitleSize') ? options.kpiTitleSize : 14,
                kpiAutoScale: options.hasOwnProperty('kpiAutoScale') ? options.kpiAutoScale : false
            };
        }


        /**
         * @name execute
         * @desc add the ornaments
         * @returns {void}
         */
        function execute() {
            scope.widgetCtrl.execute([{
                'type': 'panel',
                'components': [
                    scope.widgetCtrl.panelId
                ]
            },
            {
                'type': 'addPanelOrnaments',
                'components': [{
                    'tools': {
                        'individual': {
                            'KPI': scope.kpiSettings.options
                        }
                    }
                }],
                'terminal': true
            },
            {
                'type': 'panel',
                'components': [
                    scope.widgetCtrl.panelId
                ]
            },
            {
                'type': 'retrievePanelOrnaments',
                'components': ['tools'],
                'terminal': true
            }
            ]);
        }

        /**
         * @name reset
         * @desc remove the ornaments
         * @returns {void}
         */
        function reset() {
            // TODO: reset is not exposed because the way we set tools doesn't work properly.
            // it comes back without the KPI, so we keep the old ones
            scope.widgetCtrl.execute([{
                'type': 'panel',
                'components': [
                    scope.widgetCtrl.panelId
                ]
            },
            {
                'type': 'removePanelOrnaments',
                'components': ['tools.individual.KPI'],
                'terminal': true
            },
            {
                'type': 'panel',
                'components': [
                    scope.widgetCtrl.panelId
                ]
            },
            {
                'type': 'retrievePanelOrnaments',
                'components': ['tools'],
                'terminal': true
            }
            ]);
        }

        /**
         * @name initialize
         * @desc function that is called on directive load
         * @returns {void}
         */
        function initialize() {
            let updateFrameListener,
                updateTaskListener,
                updateOrnamentsListener;

            // listeners
            updateFrameListener = scope.widgetCtrl.on('update-frame', resetPanel);
            updateTaskListener = scope.widgetCtrl.on('update-task', resetPanel);
            updateOrnamentsListener = scope.widgetCtrl.on('update-ornaments', resetPanel);

            // cleanup
            scope.$on('$destroy', function () {
                updateFrameListener();
                updateTaskListener();
                updateOrnamentsListener();
            });

            resetPanel();
        }

        initialize();
    }
}
