module.exports = {
    'name': 'HeatMap',
    'icon': require('images/heatmap-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization',
            'JVChart'
        ],
        'showOn': 'none',
        'quickMenu': [
            'events',
            'unfilter'
        ]
    },
    'content': {
        'template': {
            'name': 'heatmap-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'HeatMap',
        'visibleModes': [
            'default-mode',
            'edit-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'format-data-values',
            'heatmap-legend',
            'heatmap-color',
            'bucket',
            'sort-values',
            'toggle-legend',
            'toggle-canvas',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [{
            'model': 'x',
            'name': 'X-Axis',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'validate',
            'optional': false,
            'multiField': false,
            'description': 'Try adding one dimension (i.e. Studio). The values of this dimension will represent the x-axis.'
        },
        {
            'model': 'y',
            'name': 'Y-Axis',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'validate',
            'optional': false,
            'multiField': false,
            'description': 'Try adding one dimension (i.e. Release Month). The values of this dimension will represent the y-axis.'
        },
        {
            'model': 'heat',
            'name': 'Heat',
            'acceptableTypes': [
                'NUMBER'
            ],
            'group': 'math',
            'optional': false,
            'multiField': false,
            'description': 'Try adding one numerical dimension (i.e. Movie Budget). The values of this dimension will represent the heat color.'
        },
        {
            'model': 'tooltip',
            'name': 'Tooltip',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'concat',
            'optional': true,
            'multiField': true,
            'description': 'Try adding one or several dimensions (i.e. Director). Each instance of this dimension will appear in the tooltip when hovering.'
        }
        ],
        'color': {
            'value': {
                'multiField': false,
                'instances': false
            },
            'group': {
                'multiField': true,
                'instances': false
            }
        }
    },
    'tools': {
        'color': 'Red',
        'toggleLegend': false,
        'buckets': '10',
        'colorLabel': 'none',
        'min': '0',
        'max': '10',
        'domainArray': '',
        'colors': [
            '#fbf2d2',
            '#fdedb5',
            '#fee7a0',
            '#ffda84',
            '#ffc665',
            '#feb44e',
            '#fea743',
            '#fd9b3f',
            '#fd8c3c',
            '#fd7735',
            '#fd602f',
            '#fb4b29',
            '#f43723',
            '#ea241e',
            '#e0161c',
            '#d60b20',
            '#c80324',
            '#b10026',
            '#870025',
            '#620023'
        ],
        'step': '1',
        'quantiles': true
    },
    'lazy': true
};
