module.exports = {
    'name': 'Grid',
    'icon': require('images/grid-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'hideHandles': [],
        'quickMenu': [
            'events',
            'unfilter',
            'color-by-value',
            'infinite-viz'
        ]
    },
    'content': {
        'template': {
            'name': 'grid-standard'
        }
    },
    'visualization': {
        'type': [
            'standard',
            'echarts'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Grid',
        'visibleModes': [
            'default-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-by-value',
            'format-data-values',
            'add',
            'sort-values',
            'reset-state',
            'show-new-column',
            'param',
            'grid-span-rows',
            'grid-full-width',
            'grid-col-style',
            'grid-wrap-text',
            'events',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': true,
        'format': 'table',
        'fields': [{
            'model': 'label',
            'name': 'Label',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': false,
            'optional': false,
            'multiField': true,
            'description': 'Select dimensions to appear in the grid.'
        }],
        'color': {}
    },
    'tools': {
        'colorByValue': false,
        'gridStylingCols': false
    },
    'lazy': true
};
