module.exports = {
    'name': 'Graph GL',
    'icon': require('images/graphgl-echarts.svg'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'quickMenu': [
            'events',
            'unfilter',
            'display-graph-values',
            'color-by-value',
            'infinite-viz'
        ]
    },
    'content': {
        'template': {
            'name': 'graphgl-echarts'
        }
    },
    'visualization': {
        'type': [
            'echarts'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'GraphGL',
        'visibleModes': [
            'default-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'display-graph-values',
            'customize-graph-label',
            'color-by-value',
            'change-layout',
            'cluster-color',
            'color-panel',
            'graph-remove-intermediary-node',
            'graph-node-details',
            'graph-connected-nodes',
            'graph-find-paths-connecting-nodes',
            'graph-find-paths-connecting-groups',
            'show-adjacent',
            'customize-symbol',
            'traverse',
            'reset-state',
            'events',
            'param',
            'refresh-cache'
        ],
        'showOnVisualPanel': true,
        'format': 'graph',
        'fields': [
            {
                'model': 'start',
                'name': 'Start',
                'acceptableTypes': [
                    'DATE',
                    'STRING',
                    'NUMBER'
                ],
                'optional': false,
                'multiField': true,
                'description': 'Try adding one or several dimensions (i.e. Nominated). Each instance of this dimension will represent a point on the graph. Each dimension is represented by a specific color. Start and End dimension of the same index will connect.'
            },
            {
                'model': 'end',
                'name': 'End',
                'acceptableTypes': [
                    'DATE',
                    'STRING',
                    'NUMBER'
                ],
                'optional': false,
                'multiField': true,
                'description': 'Try adding one or several dimensions (i.e. Producer). Each instance of this dimension will represent a point on the graph. Each dimension is represented by a specific color. Start and End dimension of the same index will connect.'
            }
        ],
        'color': {}
    },
    'state': {
        'graphLockToggle': false,
        'highlightOption': null,
        'selectedNode': null,
        'traverseList': {}
    },
    'lazy': true
};
