module.exports = {
    'name': 'Graph',
    'icon': require('images/graph-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'quickMenu': [
            'events',
            'toggle-lock',
            'unfilter',
            'display-values',
            'color-by-value',
            'infinite-viz'
        ]
    },
    'content': {
        'template': {
            'name': 'graph-echarts'
        }
    },
    'visualization': {
        'type': [
            'echarts'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Graph',
        'visibleModes': [
            'default-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'traverse',
            'customize-label',
            'change-layout',
            'color-by-value',
            'color-panel',
            'cluster-color',
            'graph-remove-intermediary-node',
            'graph-node-details',
            'graph-connected-nodes',
            'graph-find-paths-connecting-nodes',
            'graph-find-paths-connecting-groups',
            'show-adjacent',
            'show-direction',
            'toggle-legend',
            'toggle-tooltips',
            'toggle-lock',
            'toggle-svg',
            'customize-symbol',
            'node-repulsion',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': true,
        'format': 'graph',
        'fields': [
            {
                'model': 'start',
                'name': 'Start',
                'acceptableTypes': [
                    'DATE',
                    'STRING',
                    'NUMBER'
                ],
                'optional': false,
                'multiField': true,
                'description': 'Try adding one or several dimensions (i.e. Nominated). Each instance of this dimension will represent a point on the graph. Each dimension is represented by a specific color. Start and End dimension of the same index will connect.'
            },
            {
                'model': 'end',
                'name': 'End',
                'acceptableTypes': [
                    'DATE',
                    'STRING',
                    'NUMBER'
                ],
                'optional': false,
                'multiField': true,
                'description': 'Try adding one or several dimensions (i.e. Producer). Each instance of this dimension will represent a point on the graph. Each dimension is represented by a specific color. Start and End dimension of the same index will connect.'
            },
            {
                'model': 'facet',
                'name': 'Facet',
                'acceptableTypes': [
                    'STRING',
                    'DATE'
                ],
                'group': 'validate',
                'optional': true,
                'multiField': false,
                'description': 'Try adding one dimension (i.e. Genre). The data will be grouped by each instance of the selected dimension.'
            }
        ],
        'color': {}
    },
    'state': {
        'graphLockToggle': false,
        'highlightOption': null,
        'selectedNode': null,
        'traverseList': {}
    },
    'lazy': true
};
