module.exports = {
    'name': 'Gantt',
    'icon': require('images/gantt-chart.svg'),
    'widgetList': {
        'tags': [
            'Visualization',
            'JVChart'
        ],
        'showOn': 'none',
        'hideHandles': [],
        'quickMenu': [
            'events',
            'unfilter',
            'color-panel-mode',
            'color-by-value'
        ]
    },
    'content': {
        'template': {
            'name': 'gantt-standard'
        }
    },
    'visualization': {
        'type': [
            'standard',
            'echarts'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Gantt',
        'visibleModes': [
            'default-mode',
            'edit-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-panel',
            'color-by-value',
            'format-data-values',
            'sort-values',
            'toggle-legend',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [{
            'model': 'group',
            'name': 'Group',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'optional': false,
            'multiField': false
        },
        {
            'model': 'start',
            'name': 'Start',
            'acceptableTypes': [
                'DATE'
            ],
            'optional': false,
            'multiField': true
        },
        {
            'model': 'end',
            'name': 'End',
            'acceptableTypes': [
                'DATE'
            ],
            'optional': false,
            'multiField': true
        }
        ],
        'color': {
            'start': {
                'multiField': true,
                'instances': false
            },
            'end': {
                'multiField': true,
                'instances': false
            }
        }
    },
    'tools': {
        'readOnly': false
    },
    'lazy': true
};
