module.exports = {
    'name': 'Dendrogram',
    'icon': require('images/dendrogram-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'quickMenu': [
            'events',
            'unfilter',
            'color-by-value'
        ]
    },
    'content': {
        'template': {
            'name': 'dendrogram-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Dendrogram',
        'visibleModes': [
            'default-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-by-value',
            'collapse-all',
            'sort-values',
            'toggle-canvas',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'fields': [{
            'model': 'dimension',
            'name': 'Dimension',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'optional': false,
            'multiField': true,
            'description': 'Try adding one or several dimensions (i.e. Movie Genre and Studio). Each instance of the dimension will represent a branch of its parent tree.'
        }],
        'color': {}
    },
    'lazy': true
};
