module.exports = {
    'name': 'Cloud',
    'icon': require('images/cloud-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization',
            'JVChart'
        ],
        'showOn': 'none',
        'hideHandles': [],
        'quickMenu': [
            'events',
            'unfilter',
            'color-panel-mode',
            'color-by-value'
        ]
    },
    'content': {
        'template': {
            'name': 'cloud-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Cloud',
        'visibleModes': [
            'default-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-panel',
            'color-by-value',
            'format-data-values',
            'toggle-canvas',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [{
            'model': 'label',
            'name': 'Words',
            'acceptableTypes': [
                'STRING'
            ],
            'group': 'validate',
            'optional': false,
            'multiField': false,
            'description': 'Try adding one dimension (i.e. Movie Studio). The value of each instance of this dimension will be displayed in the cloud.'
        },
        {
            'model': 'value',
            'name': 'Size',
            'acceptableTypes': [
                'NUMBER'
            ],
            'group': 'math',
            'optional': false,
            'multiField': false,
            'description': 'Try adding one numerical dimension (i.e. Movie Budget). This represents the size of its respective label.'
        }
        ],
        'color': {
            'label': {
                'multiField': false,
                'instances': false
            },
            'value': {
                'multiField': false,
                'instances': false
            }
        }
    },
    'lazy': true
};
