module.exports = {
    'name': 'Remove Columns',
    'description': 'Remove the selected column from your data.',
    'icon': require('images/times-circle.svg'),
    'widgetList': {
        'showOn': 'none'
    },
    'required': {
        'R': [
            'data.table'
        ],
        'Frame': ['R', 'PY']
    },
    'content': {
        'json': [
            {
                'query': '<SMSS_FRAME.name> | DropColumn(columns=[<columns>]);<SMSS_AUTO>',
                'label': 'Remove Column',
                'description': 'Remove a column from your data.',
                'listeners': [
                    'updateTask',
                    'updateFrame',
                    'addedData',
                    'selectedData'
                ],
                'params': [
                    {
                        'paramName': 'columns',
                        'view': {
                            'displayType': 'checklist',
                            'label': 'Select a column to drop:',
                            'attributes': {
                                'display': 'alias',
                                'value': 'alias',
                                'multiple': true,
                                'searchable': true,
                                'quickselect': true
                            }
                        },
                        'model': {
                            'query': '<SMSS_FRAME.name> | FrameHeaders();',
                            'autoSelect': true
                        }
                    }
                ],
                'execute': 'button'
            }
        ]
    },
    'pipeline': {
        'group': 'Transform'
    }
};
