module.exports = {
    'name': 'Auto Clean Column',
    'description': 'Automatically clean column',
    'icon': require('images/wand.svg'),
    'widgetList': {
        'showOn': 'none'
    },
    'required': {
        'R': ['data.table', 'stringdist', 'tm', 'cluster'],
        'Frame': ['R']
    },
    'content': {
        'json': [
            {
                'query': '<SMSS_FRAME.name> | AutoCleanColumn(column=["<columnName>"], override=[<boolean>]);<SMSS_AUTO>',
                'label': 'Auto Clean',
                'description': 'Automatically cleans misspelled values in a column (i.e. Drama, Dramma, Drma -> all Drama).',
                'params': [
                    {
                        'paramName': 'columnName',
                        'view': {
                            'displayType': 'dropdown',
                            'label': 'Select a column to clean:',
                            'attributes': {
                                'display': 'alias',
                                'value': 'alias'
                            }
                        },
                        'model': {
                            'query': '<SMSS_FRAME.name> | FrameHeaders(headerTypes=["STRING"]);<SMSS_AUTO>',
                            'autoSelect': true
                        }
                    },
                    {
                        'paramName': 'boolean',
                        'view': {
                            'displayType': 'dropdown',
                            'label': 'Replace existing values with the results:',
                            'description': "'True' will override the current column values, while 'False' will generate a new column."
                        },
                        'model': {
                            'defaultOptions': [
                                'true',
                                'false'
                            ],
                            'defaultValue': 'false'
                        },
                        'required': true,
                        'link': 'instance'
                    }
                ],
                'execute': 'button'
            }
        ]
    },
    'pipeline': {
        'group': 'Transform'
    }
};
