module.exports = {
    'name': 'Column',
    'icon': require('images/bar-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization',
            'JVChart'
        ],
        'showOn': 'none',
        'hideHandles': [],
        'quickMenu': [
            'events',
            'unfilter',
            'color-panel-mode',
            'color-by-value',
            'flip-axis',
            'reverse-y',
            'infinite-viz'
        ]
    },
    'content': {
        'template': {
            'name': 'bar-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Column',
        'visibleModes': [
            'default-mode',
            'edit-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-panel',
            'color-by-value',
            'display-values',
            'format-data-values',
            'flip-axis',
            'flip-series',
            'reverse-y',
            'sort-values',
            'toggle-legend',
            'toggle-stack',
            'toggle-canvas',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [{
            'model': 'label',
            'name': 'X-Axis',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'validate',
            'optional': false,
            'multiField': false,
            'description': 'Try adding one categorical dimension (i.e. Movie Genre). Each instance within this dimension will appear on the x-axis.'
        },
        {
            'model': 'value',
            'name': 'Y-Axis',
            'acceptableTypes': [
                'NUMBER'
            ],
            'group': 'math',
            'optional': false,
            'multiField': true,
            'description': 'Try adding one or several dimensions (i.e. Movie Budget). The numerical values of these dimensions will represent their respective column size.'
        },
        {
            'model': 'tooltip',
            'name': 'Tooltip',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'concat',
            'optional': true,
            'multiField': true,
            'description': 'Try adding one or several dimensions (i.e. Director). Each instance of this dimension will appear in the tooltip when hovering.'
        }
        ],
        'color': {
            'value': {
                'multiField': true,
                'instances': false
            }
        }
    },
    'lazy': true
};
