const merge = require('webpack-merge'),
    common = require('./webpack.common.js'),
    MiniCssExtractPlugin = require('mini-css-extract-plugin'),
    HtmlWebpackPlugin = require('html-webpack-plugin');

module.exports = merge(common, {
    mode: 'development',
    stats: {
        children: false
    },
    output: {
        filename: '[name].js',
        chunkFilename: '[name].js'
    },
    devServer: {
        historyApiFallback: true,
        noInfo: true,
        overlay: true,
        stats: {
            children: false
        }
    },
    devtool: 'eval',
    plugins: [
        new MiniCssExtractPlugin({
            filename: '[name].css',
            chunkFilename: '[name].css'
        }),
        new HtmlWebpackPlugin({
            template: './core/template.ejs',
            filename: '../index.html',
            inject: false
        })
    ]
});
