const path = require('path'),
    webpack = require('webpack'),
    {
        CleanWebpackPlugin
    } = require('clean-webpack-plugin'),
    MiniCssExtractPlugin = require('mini-css-extract-plugin');

module.exports = {
    entry: {
        polyfills: './polyfills/polyfills.js',
        core: './core/entry.js'
    },
    output: {
        publicPath: './dist/',
        path: path.resolve(__dirname, './dist')
    },
    module: {
        rules: [
            {
                test: /\.scss$/,
                use: [{
                    loader: MiniCssExtractPlugin.loader,
                    options: {
                        publicPath: '../'
                    }
                },
                'css-loader',
                'sass-loader'
                ]
            },
            {
                test: /\.css$/,
                use: [{
                    loader: MiniCssExtractPlugin.loader
                },
                'css-loader'
                ]
            },
            {
                test: /\.html$/,
                use: {
                    loader: 'html-loader',
                    options: {
                        minimize: true
                    }
                }
            },
            {
                test: /\.(js|ts)$/,
                exclude: /(node_modules|bower_components)/,
                use: {
                    loader: 'babel-loader',
                    options: {
                        presets: ['@babel/env'],
                        plugins: ['@babel/plugin-syntax-dynamic-import']
                    }
                }
            },
            {
                test: /\.(png|jpg|jpeg|gif|svg)$/,
                use: {
                    loader: 'url-loader',
                    options: {
                        limit: 8192,
                        outputPath: './images'
                    }
                }
            },
            {
                test: /\.(woff|woff2|ttf|eot)$/,
                use: {
                    loader: 'file-loader',
                    options: {
                        outputPath: './fonts',
                        publicPath: './fonts'
                    }
                }
            }
        ]
    },
    optimization: {
        splitChunks: {
            chunks: 'all',
            minSize: 30000,
            // maxSize: 0,
            minChunks: 1,
            maxAsyncRequests: 5,
            maxInitialRequests: 3,
            automaticNameDelimiter: '~',
            // automaticNameMaxLength: 30,
            name: true,
            cacheGroups: {
                vendors: {
                    test: /([\\/]node_modules[\\/]|[\\/]widget-resources[\\/])/,
                    priority: -10,
                    chunks: 'all'
                },
                default: {
                    minChunks: 2,
                    priority: -20,
                    reuseExistingChunk: true
                }
            }
        }
    },
    resolve: {
        alias: {
            '@': path.resolve(__dirname, './'),
            'images': path.resolve(__dirname, './core/resources/img'),
            'theme$': path.resolve(__dirname, './style/src/theme.scss')
        },
        extensions: ['*', '.js', '.json', '.ts', '.scss', '.css']
    },
    plugins: [
        new CleanWebpackPlugin({
            cleanStaleWebpackAssets: false
        }),
        new webpack.ProvidePlugin({
            'jQuery': 'jquery',
            '$': 'jquery',
            'window.jQuery': 'jquery',
            'window.$': 'jquery'
        })
    ]
};
