import './smss-overlay.scss';

export default angular.module('smss-style.overlay', [])
    .directive('smssOverlay', smssOverlay);

smssOverlay.$inject = ['$timeout'];

function smssOverlay($timeout) {
    smssOverlayLink.$inject = ['scope', 'ele', 'attrs'];

    return {
        restrict: 'EA',
        template: require('./smss-overlay.directive.html'),
        scope: {
            open: '=',
            disableClick: '=?',
            exit: '&?'
        },
        replace: true,
        transclude: true,
        link: smssOverlayLink
    };

    function smssOverlayLink(scope, ele, attrs) {
        var containerEle,
            contentEle;

        /**
         * @name setContent
         * @desc if open or closed add or remove the content
         * @returns {void}
         */
        function setContent() {
            if (scope.open) {
                addContent();
            } else {
                removeContent();
            }
        }

        /**
         * @name addContent
         * @desc actually add the content to the view
         * @returns {void}
         */
        function addContent() {
            // clear the display
            contentEle.style.display = '';

            containerEle.appendChild(contentEle);
        }

        /**
         * @name removeContent
         * @desc remove the content element from the view
         * @returns {void}
         */
        function removeContent() {
            if (contentEle) {
                if (contentEle.parentNode !== null) {
                    contentEle.parentNode.removeChild(contentEle);
                }
            }
        }

        /**
         * @name exit
         * @desc exit the overlay
         * @returns {void}
         */
        function exit() {
            scope.open = false;
        }

        /**
         * @name initialize
         * @desc called when the directive is loaded
         * @returns {void}
         */
        function initialize() {
            if (attrs.hasOwnProperty('body')) {
                scope.body = !(attrs.body === 'false');
            } else {
                scope.body = true;
            }


            if (!scope.exit) {
                scope.exit = exit;
            }

            // this is the content
            contentEle = ele[0];

            if (scope.body) {
                containerEle = document.body;
            } else {
                containerEle = ele[0].parentNode;
            }

            // hide the element
            contentEle.style.display = 'none';

            // set the content after it has been compiled (so we can require parent directives...)
            $timeout(function () {
                setContent();

                scope.$watch('open', function (newVal, oldVal) {
                    if (newVal !== oldVal) {
                        setContent();
                    }
                });
            });
        }

        initialize();
    }
}
