export default angular.module('docs.color', [])
    .directive('colorSection', colorDirective);

import './color.scss';

function colorDirective() {
    colorLink.$inject = ['scope'];
    return {
        restrict: 'E',
        template: require('./color.directive.html'),
        replace: true,
        link: colorLink
    };

    function colorLink(scope) {
        scope.groups = [{
            title: 'Core',
            colors: [
                {
                    name: 'primary, highlight',
                    code: '#00A8C1'
                },
                {
                    name: 'nav, text',
                    code: '#1F2238'
                }
            ]
        }, {
            title: 'Greys',
            colors: [
                {
                    name: 'action, background',
                    code: '#F8F8F9'
                },
                {
                    name: 'disabled, border, scroll-thumb',
                    code: '#EFEFEF'
                },
                {
                    name: 'action-dark',
                    code: '#E4E5E7'
                },
                {
                    name: 'label, description',
                    code: '#6E758B'
                },
                {
                    name: 'title',
                    code: '#4C4D5F'
                }
            ]
        }, {
            title: 'Status',
            colors: [
                {
                    name: 'success',
                    code: '#52CF87'
                },
                {
                    name: 'warn',
                    code: '#FFD250'
                },
                {
                    name: 'error',
                    code: '#EB6456'
                }
            ]
        }];
    }
}
