import angular from 'angular';

/**
 * @name smssInterceptor.service.js
 */
export default angular.module('app.semoss-interceptor.service', [])
    .factory('semossInterceptorService', semossInterceptorService);

semossInterceptorService.$inject = ['optionsService'];

function semossInterceptorService(optionsService: OptionsService) {
    /**
     * @name requestInterceptor
     * @param {object} config the param passed into requests
     * @desc    interceptors get called with a http config object.
     *          The function is free to modify the config object or create a new one.
     *          The function needs to return the config object directly, or a promise
     *          containing the config or a new config object.
     * @returns {object} the modified config object
     */
    function request(config: { url: string, data: string }): { url: string, data: string } {
        let additionalParams: { restParams: any }, postData: string;
        if (config.url.indexOf('runPixel') > -1) {
            additionalParams = optionsService.get('options');
            postData = config.data;

            if (additionalParams && additionalParams.restParams) {
                for (let key in additionalParams.restParams) {
                    if (additionalParams.restParams.hasOwnProperty(key)) {
                        postData += '&' + key + '=' + additionalParams.restParams[key];
                    }
                }
            }

            config.data = postData;
        }

        return config;
    }

    /**
      * @name initialize
      * @desc called when the module is loaded
      */
    function initialize(): void {}

    initialize();

    return {
        'request': request
    };
}
