import angular from 'angular';
import Utility from '../../utility/utility.js';

/**
 * @name pipeline.service.js
 * @desc the pipeline service is the layer that supports and stores widget pipeline information
 */
export default angular.module('app.pipeline.service', [])
    .factory('pipelineService', pipelineService);

pipelineService.$inject = ['messageService'];

function pipelineService(messageService: MessageService) {
    const _state = {
            start: [],
            complete: [],
            shared: {}
        },
        _actions = {
            'set-pipeline': function (payload) {
                if (!_state.shared.hasOwnProperty(payload.insightID)) {
                    _state.shared[payload.insightID] = {
                        components: {}
                    };
                }

                _state.shared[payload.insightID] = payload.pipeline;
            }
        };

    /**
     * @name initialize
     * @desc called when the module is loaded
     * @return {void}
     */
    function initialize(): void {
        for (let a in _actions) {
            if (_actions.hasOwnProperty(a)) {
                messageService.on(a, _actions[a]);
            }
        }
    }

    /**
     * @name get
     * @param id the insight id to set to
     * @param accessor - string to get to the object. In the form of 'a.b.c'
     * @desc function that gets data from the state
     * @returns value of the requested object
     */
    function get(id: string, accessor?: string): any {
        if (!_state[id]) {
            return false;
        }

        return Utility.getter(_state[id], accessor);
    }

    return {
        initialize: initialize,
        get: get
    };
}
